(function($){
/*
 * Редактирование медиаплана, разбитые ключевые фразы
 */
    var iModelsManager = BEM.blocks['i-models-manager'];

    BEM.DOM.decl('b-mediaplan-form-phrases-splited', {
        onSetMod: {
            'js': function(){
                //счетчик новых фраз
                this.newCounter = 0;
                this.model = iModelsManager.get('campaign&banner:' + this.params.bid, 'b-banner-edit')
                    .onField('phrases_to_split', 'change', function() {
                        var toSplit = this.model.get('phrases_to_split');
                        !direct.utils.isEmpty(toSplit) && this.splitWords(toSplit);
                    }, this);
                this.initPhrases();

                this.updateAllPhrasesThrottle = $.throttle(this.updateAllPhrases, 100, this);

                BEM.blocks['b-mediaplan-form-phrases-splited'].on('phrase-delete', this.updateAllPhrasesThrottle, this);
            }
        },

        /**
         * Разбиваем новые ключевые фразы
         * @protected
         * @returns {BEM}
         */
        splitWords: function(toSplit) {
            var data = {
                cmd: 'ajaxTestPhrases',
                phrases: toSplit
            };

            $.ajax({
                url: '/registered/main.pl',
                dataType: 'xml',
                data: data,
                type: 'POST',
                success: $.proxy(this.onSplitedPhraseLoaded, this)
            });
        },

        onSplitedPhraseLoaded: function(res) {
            var error = $(res).find('error');

            if (error.length > 0) {
                var errorCode = error.text();
                this.model.trigger('split-phrases-error');
                this.model.validator.setErrorManual('all_phrases', errorCode);
                BEM.blocks['b-banner-edit'].trigger('errors.reset');
            } else {
                var _this = this;
                this.model.validator.clearField('all_phrases');
                this.model.set('phrases_to_split', '');

                $(res).find('phrase').each(function(i) {
                    var phrase = $.trim($(this).text()),
                        path = 'campaign&banner:' + _this.params.bid + '&type:new&phrase:' + _this.newCounter;

                    var m = iModelsManager.get(path, 'b-mediaplan-form-phrase-splited');
                    m.initData({phrase: phrase, id: 0, can_delete: 1});
                    _this.elem('new')
                        .append(BEM.HTML.build({
                        block: 'b-mediaplan-form-phrase-splited',
                        phrase: phrase,
                        type: 'new',
                        bannerPath: 'campaign&banner:' + _this.params.bid,
                        path: path
                    }));
                    _this.newCounter++;
                });

                this.findBlocksInside(this.elem('new'), 'b-mediaplan-form-phrase-splited');

                this.updateAllPhrases();

                this.model.trigger('split-phrases-loaded');
            }
        },

        /**
         * Инициализируем содержащиеся в моделях ключевые фразы и распихиваем их по блокам
         * активные/отклонённые/отключенные за низкий ctr
         * @protected
         * @returns {BEM}
         */
        initPhrases: function() {
            var _this = this;

            $.each(['new', 'active', 'declined', 'low-ctr'], function(i, type) {

                if (!_this.elem(type).length) { return true; }
                iModelsManager
                    .eachModel(function(id, model) {
                        if (type == 'new') { _this.newCounter++; }
                        _this.elem(type)
                            .append(BEM.HTML.build({
                                block: 'b-mediaplan-form-phrase-splited',
                                phrase: model.get('phrase'),
                                type: type,
                                bannerPath: 'campaign&banner:' + _this.params.bid,
                                path: model.path()
                        }))
                    }, 'campaign&banner:' + _this.params.bid + '&type:' + type + '&phrase:*', 'b-mediaplan-form-phrase-splited')


            });
            this.findBlocksInside('b-mediaplan-form-phrase-splited');

            this.updateAllPhrases();

            return this;
        },

        updateAllPhrases: function() {
            var allPhrases = [];
            iModelsManager.eachModel(function(id, model) {
                    allPhrases.push(model.get('phrase'));
                }, 'campaign&banner:' + this.params.bid + '&type:*&phrase:*', 'b-mediaplan-form-phrase-splited', true);
            this.model.set('all_phrases', allPhrases.join(','));

            return this;
        }
    });

})(jQuery);
