(function($){
    //блок для ввода новых фраз в редактировании медиаплана
    var iModelsManager = BEM.blocks['i-models-manager'];
    BEM.DOM.decl('b-mediaplan-form-phrases', {
        onSetMod: {
            'js': function(){
                this.phraseCountLimit = this.params.phraseCountLimit;
                this.model = iModelsManager.get(this.params.modelPath, 'b-banner-edit');
                this.regionModel = iModelsManager.get(this.params.modelPath, 'b-regions-tree');

                this.model
                    .on('split-phrases', this.onSplit, this)
                    .onField('new_phrases', 'change', function(e, data) {
                        if (data.source === this) return;
                        this.elem('input').val(this.model.get('new_phrases'));
                    }, this)
                    .on('split-phrases-error', this.onSplitError, this);

                this
                    .bindTo('input', 'change', this.update.bind(this))
                    .bindTo('clear', 'click', this.onClear)
                    .bindTo('split', 'click', this.onSplit)
                    .bindTo('advq-link', 'click', this.onSelect);
            }
        },

        update: function() {
            var value = this.elem('input').val();
            this.model.set('new_phrases', value, this);
        },

        onSelect: function(e) {
            e.preventDefault();

            var dom = document.location.host.replace(/forum./, '');
            var url = document.location.protocol + "//" + dom + "/registered/main.pl?cmd=wordstat&text=&suffix=" + this.model.get('bid') + "&key=" + key + "&tm=" + time + (this.regionModel.get('geo') ? '&geo=' + this.regionModel.get('geo') : '');
            direct.utils.openWindow(url, "words_window", 800, 600);
        },

        onClear: function() {
            this.elem('input').val('');
            this.model.set('new_phrases', '');
        },

        onSplit: function() {
            var value = this.model.get('new_phrases');
            if (direct.utils.isEmpty(value)) {
                this.model.trigger('split-phrases-loaded');
            }

            this.onClear();
            this.model.set('phrases_to_split', value);
        },

        onSplitError: function() {
            this.elem('input').val(this.model.get('phrases_to_split'));
        }
    });

})(jQuery);
