(function($){

BEM.DOM.decl('b-mediaplan-prices-edit', {
    onSetMod: {
        'js': function(){
            this.campModel = BEM.blocks['i-models-manager'].get('campaign', 'b-mediaplan-view');


            this.submit = this.findBlockOn(this.elem('submit'), 'b-form-button')
                .on('click', this.onSubmit, this);

            this.submitBack = this.findBlockOn(this.elem('submit-back'), 'b-form-button')
                .on('click', this.onSubmitBack, this);

            if (this.campModel.get('phrases_inited')) {
                this.disableButtons(false);
            } else {
                this.campModel.onField('phrases_inited', 'change', function() {
                    this.disableButtons(false);
                }, this)
            }
            this.initHeader();

        }
    },

    disableButtons: function(disabled) {
        var disableState = disabled ? 'yes' : 'no';


        this.submit.setMod('disabled', disableState);
        this.submitBack.setMod('disabled', disableState);
    },

    initHeader: function() {
        var word = this.elem('prices').find('.b-phrases-list-phrase__word-column');
        if (word) {
            this.elem('prices-header').find('.b-phrases-list-phrase__word-column').css('width', word.width() + 'px')
        }
    },

    onSubmit: function() {
        var phrasesData = {}, retargetingsData = {}, length = 0, activeCount = {};
        this.disableButtons(true);

        BEM.blocks['i-models-manager'].eachModel(function(i, model) {
            var bannerId = model.get('bannerId');

            if (!phrasesData[bannerId]) {
                phrasesData[bannerId] = [];
                activeCount[bannerId] = 0;
                length++;
            }
            //внезапно - похоже active = 0 обозначает включенную фразу O_O
            if (!model.get('active')) {
                activeCount[bannerId]++
            }
            var result =  $.trim(model.get('phrase')) +
                "#" + model.get('active') +
                "#" + model.get('place') +
                "#" + model.get('id0') +
                "#" + model.get('numword') +
                "#" + model.get('shows') +
                '#' + model.get('old_id');

            phrasesData[bannerId].push(result);
        }, 'campaign&banner:*&phrase:*', 'b-phrases-list-phrase');

        BEM.blocks['i-models-manager'].eachModel(function(i, model) {
            var bannerId = model.get('bannerId');

            if (!retargetingsData[bannerId]) {
                retargetingsData[bannerId] = [];
            }
            //внезапно - похоже active = 0 обозначает включенную фразу O_O
            if (!model.get('active')) {
                retargetingsData[bannerId].push(model.get('ret_cond_id'));
            }
        }, 'campaign&banner:*&retargeting:*', 'b-phrases-list-phrase');

        var validate = true;

        $.each(activeCount, function(i, length) {
            if (length == 0) {
                validate = false;
                return false;
            }
        });
        if (!validate) {
            alert(iget('Необходимо добавить Ключевые слова'));
            this.disableButtons(false);
            return;
        }

        var _this = this;

        $.each(phrasesData, function(bid, phraseArray) {
            _this.elem('result-phrases', 'bid', bid).val(phraseArray.join(','));
        });

        $.each(retargetingsData, function(bid, retargetingsArray) {
            _this.elem('result-retargetings', 'bid', bid).val(retargetingsArray.join(','));
        });

        this.elem('form').submit();
    },

    onSubmitBack: function() {
        this.disableButtons(true);

        this.elem('action').val(this.params.backAction);
        var phrasesData = {}, length = 0;
        BEM.blocks['i-models-manager'].eachModel(function(i, model) {
            if (!phrasesData[model.get('bannerId')]) {
                phrasesData[model.get('bannerId')] = [];
                length++;
            }
            phrasesData[model.get('bannerId')].push($.trim(model.get('phrase')) + '::' + model.get('id0') + '::' + model.get('numword'));
        }, 'campaign&banner:*&phrase:*', 'b-phrases-list-phrase');


        var html = [];
        $.each(phrasesData, function(bid, phraseArray) {
            html.push({
                tag: 'input',
                attrs: {
                    type: 'hidden',
                    name: 'phrases' + (bid == 0 ? '' : '-' + bid),
                    value: phraseArray.join(',')
                }
            })
        });

        this.elem('form').append(BEM.HTML.build(html));

        //почему-то если засабмитить сразу нода не аппендится
        var _this = this,
            timeout = setTimeout(function() {
             clearTimeout(timeout);
            _this.elem('form').submit()
        }, 42)
    }
});

})(jQuery);
