(function($, Lego) {
    Lego.block['b-mediaplan-request'] = function(params) {

        var $this = $(this),
            mediaTypeSelect = $this.find('.b-mrequest__mediatype-select'),
            optimizeMediaTr = $this.find('.b-mrequest__optimize-media-tr'),
            sitekeywordsMediaTr = $this.find('.b-mrequest__sitekeywords-media-tr'),
            targetSelect = $this.find('.b-mrequest__target'),
            targetText = $this.find('.b-mrequest__target-text'),
            checkboxes = $this.find('.b-mrequest__checkbox'),
            checkboxesFields = $this.find('.b-mrequest__checkbox-field'),
            textMediaTr = $this.find('.b-mrequest__text-media-tr'),
            $geoType = $this.find('.b-mrequest__geotype'),
            $regSelector = $this.find('.b-region-selector').eq(0);

        mediaTypeSelect.change(onMediaTypeChange);
        targetSelect.change(onTargetChange);
        $.each(checkboxes, function(i, element) {
            $(element).bind('click', {num: i}, onCheckboxClick)
        });

        $geoType.click(function(e) {
            if (e.target.nodeName.toLowerCase() == 'input' && e.target.type == 'radio') {
                toggleRegionSelector(e.target.value === '0');
            }
        });

        toggleRegionSelector($geoType.find('input[type=radio]:checked').val() === '0');

        function toggleRegionSelector(mustHide) {
            $regSelector.toggleClass('g-hidden', mustHide);
        }

        function onTargetChange(e) {
            targetText.toggleClass('g-hidden', this.value == '')
        }

        function onCheckboxClick(e) {
            var num = e.data.num;
            checkboxesFields.get(num).disabled  = this.checked ? '' : 'disabled';
        }
        function onMediaTypeChange() {
            var value = $(this).val();

            $.each([
                [textMediaTr, value != 'text'],
                [optimizeMediaTr, !value.match('optimiz')],
                [sitekeywordsMediaTr, !value || !value.match(/text|keywords/)]
            ], function(i, tr){
                tr[0].toggleClass('g-hidden', tr[1])
                    .find('.g-common__checkbox').prop('disabled', tr[1]);
            });
        }

    }
})(jQuery, window.Lego);
