(function($){
//поиск по блокам в медиаплане
BEM.DOM.decl('b-mediaplan-search-block', {
    doSearch: function() {
        this.checkResult();
    },


    checkResult: function() {
        $.getJSON('/registered/main.pl', {
            'cmd': 'ajaxGetMediaplanBannersCount',
            'cid': this.elem('cid').val(),
            'wo_phrases': this.elem('no-phrases-radio').prop('checked') ? true : false,
            'vcard_wo_href': this.elem('with-vcard-radio').prop('checked') ? true : false
        }, $.proxy(this.onResultLoaded, this))
    },

    onResultLoaded: function(res) {
        if (res != 0) {
            this.submitForm();
        } else {
            if (!confirm(iget('Ничего не найдено, продолжать поиск?'))) this.popupa.hide();
        }
    },

    submitForm: function() {
        if (this.elem('no-phrases-radio').prop('checked')) this.elem('no-phrases').val(1);
        if (this.elem('with-vcard-radio').prop('checked')) this.elem('with-vcard').val(1);
        this.elem('form').submit();
        this.popupa.hide();
    },

    getPopup: function() {
        if (this.popupa) { return this.popupa; }
        this.popupa = this.findBlockInside('b-popupa');
        this.okBtn = this.findBlockOn(this.elem('ok'), 'b-form-button')
            .on('click', this.doSearch, this);
        this.cancelBtn = this.findBlockOn(this.elem('cancel'), 'b-form-button')
            .on('click', function() {
                this.popupa.hide();
            }, this);
        //кэшируем элементы попапа
        this.elem('no-phrases-radio');
        this.elem('with-vcard-radio');

        return this.popupa;
    },

    toggle: function() {
        this.getPopup().toggle(this.elem('link'))
    }
}, {
    live: function(){
        this.liveBindTo('link', 'click', function() {
            this.toggle();
        })
    }
});

})(jQuery);
