(function($){
/*
 * Групповые операции с фразами на странице просмотра медиаплана
 */
    var iModelManager = BEM.blocks['i-models-manager'];

BEM.DOM.decl('b-mediaplan-view-phrases-actions', {
    onSetMod: {
        'js': function(){
            this.phrasesPath = 'campaign&banner:*&phrase:*';
            this.retargetingsPath = 'campaign&banner:*&retargeting:*';
        }
    },

    onSubmit: function() {
        this.elem('submit').prop('disabled', true);
        var actionVal = this.elem('action').val();
        if ( actionVal!= '') {
            if( actionVal == 'delPhrases' ) {
                if( !confirm(iget("Вы действительно хотите удалить выбранные фразы?")) ) {
                    this.elem('submit').prop('disabled', false);
                    return false;
                }
                this.elem('cmd').val('delMediaplanPhrases');
            }

            var phrasesIds = [], retargetingsIds = [];

            iModelManager.eachModel(function(id, model) {
                if (model.get('selected')) {
                    phrasesIds.push(model.get('phraseId') + (actionVal != "delPhrases" ? ':' + model.get('numword') : ''));
                }
            }, this.phrasesPath, 'b-phrases-list-phrase');

            iModelManager.eachModel(function(id, model) {
                if (model.get('selected')) {
                    retargetingsIds.push(model.get('phraseId'));
                }
            }, this.retargetingsPath, 'b-phrases-list-phrase');


            if( phrasesIds.length == 0 && retargetingsIds.length == 0) {
                this.elem('submit').prop('disabled', false);
                alert(iget("Выберите фразы для данного действия"));
                return false;
            }
            this.elem('ids-phrases').val(phrasesIds.join( "," ))
            this.elem('ids-retargetings').val(retargetingsIds.join( "," ))
            this.domElem.submit();
        } else {
            alert(iget("Выберите действие с выделенными объектами"));
            this.elem('submit').prop('disabled', false);
            return false;
        }

    }
}, {
    live: function(){
        this.liveBindTo('submit', 'click', function() {
            this.onSubmit();
        })
    }
});

})(jQuery);
