(function($){
    /*
     * Общий js для работы со страницей просмотра блоков медиаплана. Используется в шаблоне data\t\media_show_plan.html
     * Аналог b-campaign-view для страницы медиаплана
     */
    BEM.blocks['b-model'].register('b-mediaplan-view', {
        fields: {
            'currency': {type: 'string', fromServer: 1},
            'phrases_inited': {type: 'flag'}
        }
    });

    BEM.DOM.decl({name:'b-mediaplan-view', baseBlock: 'b-model-block'}, {
        onSetMod: {
            'js': function(){
                this.__base();

                var _this = this;
                this.model.onFirst('b-phrases-list-models:init', function(){
                    $.map(['phrase', 'retargeting'], function(name) {
                        _this[name + 'Models'] = BEM.blocks['i-models-manager'].getGroup('campaign&banner:*&' + name + ':*', 'b-phrases-list-phrase');
                    });
                }, this);

                var savePricesBtn = this.findBlockOn(this.elem('save-btn'), 'b-form-button');
                savePricesBtn && savePricesBtn.on('click', this.savePrices, this);
            }
        },

        savePrices: function() {
            var content = [], contentRetargeting = [];
            $.map(this.retargetingModels, function(model) {
                contentRetargeting.push(model.get('phraseId') + '-' + model.get('place'));
            });

            $.map(this.phraseModels, function(model) {
                content.push(model.get('phraseId') + '-' + model.get('place'));
            });

            this.elem('content').val(content.join(':'));
            this.elem('content-retargeting').val(contentRetargeting.join(':'));

            this.elem('save-form').submit();
        }
    });

})(jQuery);
