(function($) {
    //utility - вспомогательное поле
    //server - отправляется на сервер
    //serverName - имя для хранения на сервере
    //input - напрямую вводится пользователем

    BEM.blocks['b-model'].register('b-metrika-counter', {
        fields: {
            'metrika_counters': {type: 'string', fromServer: 1, toServer: 1, input: 1}
        },

        validateRules: {
            'metrika_counters': {
                list: [
                    {
                        max: 5,
                        id: 'maxlength',
                        name: 'maxlength',
                        preprocess: function(value) {
                            return value.split(', ').join(' ').split(' ');
                        },
                        text: iget('Можно указать не более 5 дополнительных счетчиков Метрики')
                    },
                    {
                        id: 'maxlength_counter',
                        validator: function(value) {
                            var arr = value.split(', ').join(' ').split(' '),
                                limit = Math.pow(2, 32);
                            for (var i = 0; i < arr.length; i++) {
                                if (arr[i] >= limit) { return false; }
                            }
                            return true;
                        },
                        text: iget('Неверно указаны дополнительные счетчики Метрики')
                    },
                    {
                        id: 'field_format',
                        validator: function(str) {
                            return str.match(/^\s*([0-9]+((\s)+|(\s*,\s*)))*([0-9]*)\s*$/g);
                        },
                        text: iget('Неверно указаны дополнительные счетчики Метрики')
                    }
                ]
            }
        }
    });

    BEM.DOM.decl({name:'b-metrika-counter', baseBlock: 'b-model-block'}, {
        onSetMod: {
            js: function() {
                this.initConsts();
                this.initModel();
                this.bindEvents();
            }
        },

        initConsts: function() {
           this._modelPath = 'campaign';
           this._modelName = 'b-metrika-counter';
        },

        bindEvents: function() {
            this.bindErrorEvents();
            this.model.onField('metrika_counters', 'change', {name: 'metrika_counters'}, this.onModelChanged, this);
            this.bindTo('metrika-counters', 'change', function() {
                var value = this.elem('metrika-counters').val();
                value =  value.replace(/\s*\s/g, ' ');
                this.model.set('metrika_counters', value);
            });
        }
    }, {
        live: true,
        getText: function(ctx) {
            return ctx.model.get('metrika_counters').replace(/(\d+)\D+/g, '№$1, ').replace(/(^|\D+)(\d+)$/, '$1№$2');
        },

        getButtonText: function(ctx) {
            return ctx.model.get('metrika_counters') ? iget('изменить') : iget('задать');
        }
    });




})(jQuery);

