(function($) {
    BEM.DOM.decl({name:'b-minus-words-item'}, {
        onSetMod : {
            js: function() {
                var self = this;
                self.checkbox = self.findBlockInside('b-form-checkbox');

                self.checkbox.on('change', function(e, data) {
                    self.trigger('change', { checked: this.getMod('checked') == 'yes' ?  1 : 0})
                })
            }

        },

        setChecked: function(checked) {
            this.checkbox.toggleMod('checked', 'yes', '', checked);
        },

        word: function(v) {
            if (v === undefined) return this.elem('word').html();
            this.elem('word').html(v);
            return this;
        },

        examples: function(v) {
            if (v === undefined) return this.elem('examples').html();
            this.elem('examples').html(v);
            return this;
        },

        count: function(v) {
            this.elem('count').html ('<strong>-' + common.number.format(v, {precision: 0}) + '</strong> ' + iget('показов в месяц'));
        }
    });

    BEM.HTML.decl('b-minus-words-item', {
        onBlock : function(ctx) {
            ctx
                .tag('tr')
                .content([
                    {
                        tag: 'td',
                        cls: 'b-minus-words-list__cell b-minus-words-list__cell_check',
                        content: {
                            mix: ['b-minus-words-item__checkbox'],
                            block: 'b-form-checkbox',
                            mods: { checked: 'no' },
                            js: true,
                            checkboxAttrs: { name: 'minus-words-checkbox'  + ctx.generateId() }
                        }
                    },
                    {
                        tag: 'td',
                        cls: 'b-minus-words-list__cell b-minus-words-list__cell_word',
                        content: [
                            {
                                tag: 'div',
                                cls: 'b-minus-words-item__word',
                                content: ctx.param('word')
                            },
                            {
                                tag: 'div',
                                cls: 'b-minus-words-item__count',
                                content: '<strong>-' + ctx.param('count') + '</strong> ' + iget('показов в месяц')
                            }
                        ]
                    },
                    {
                        tag: 'td',
                        cls: 'b-minus-words-list__cell b-minus-words-list__cell_example',
                        content: {
                            tag: 'div',
                            cls: 'b-minus-words-item__examples',
                            content: ctx.param('examples')
                        }
                    }
                ])

        }
    });


})(jQuery);


