(function($) {
    var dataForWord = {};

    BEM.DOM.decl({name:'b-minus-words-list', baseBlock: 'i-minus-words'}, {

        onSetMod : {
            js: function() {
                this.inited = false;
                var self = this;
                self.__self.instance = self;
                self.model = BEM.blocks['i-models-manager'].get('campaign', 'b-edit-phrase-popup');

                self.__self.liveBindTo('load-more', 'click', $.proxy(this.onLoadMore, this));
                self.on('loaded', this.onDataLoaded, this)
                self.on('baseFormLoading', this.baseForms, this);
                self.on('count', this.writeCount, this);

                self._baseForms = {};
                self.__base();
                self.loadingSrc = '/i/wait-gray.gif';
            },

            status: function(modName, modVal) {
                this.elem('scrollpane').toggleClass('g-hidden', modVal == 'loading')
            }

        },

        switchOn: function(geo) {
            this.model.onField('minus_words', 'change', this.rewriteMinusWords, this);
            this.model.onField('key_words', 'change', this.updateMinusWords, this);
            this.geo = this.model.get('geo');
            this.generalMinusWords = this.model.get('generalMinusWords');
            //список минус-слов
            this.listItems = [];
            this.elem('words').empty();
            this.originalWord = $.trim(this.model.get('phrase'));
            this.word  = this.model.get('key_words');   // строчка текущего слова
            this._minusWords = this.rawMinusWords();
            this.writeCount({}, {count: 0, sure: 0});
            this.listData({ words: [], has_more: false, initial: true });
            this.init();
        },

        switchOff: function() {
            this.model.unField('minus_words', 'change', this.rewriteMinusWords, this);
            this.model.unField('key_words', 'change', this.updateMinusWords, this);
        },


        baseForms: function(v) {
            this._baseForms = v;
            this.updateListItems();
        },

        minusWords: function(v) {
            this._minusWords = v || [];
            this.updateListItems();
        },

        updateListItems: function() {
            var index = {};
            for (var i=0; i < this._minusWords.length; i++) {
                index[this._minusWords[i]] = true;
                var baseForms = this._baseForms[this._minusWords[i]];
                if (baseForms) for (var j=0; j < baseForms.length; j++) index[baseForms[j]] = true;
            }


            $.each(this.listItems, $.proxy(function(i, elem) {
                elem.setChecked(!!index[elem.word()]);
            }, this));


        },

        listData: function(v) {
            if (v === undefined) { return this.data }
            this.data = v;
            var views = [];

            // строчки со словами
            v.words && $.each(v.words, function(i, item) {

                views.push(BEM.HTML.build({
                    block: 'b-minus-words-item',
                    js: true,
                    word: '-' + item.word,
                    examples: item.phrases.slice(0, 5).join(', '),
                    count: item.exact_cnt || item.cnt
                }));

            });

            // кнопка загрузить еще
            this.setMod('has-more', v.has_more ? 'yes' : 'no');
            this.setMod('status', !v.has_more && v.words.length == 0 ? 'empty' : 'words');
            views.length > 0 && this.elem('words').append(views.join(''));
            this.initListItems();
            this.updateListItems();
            return this;
        },

        onCheckboxChecked: function(e, data) {
            var id = e.data.id,
                checked = data.checked,
                word = this.listItems[id].word();
            if (checked) {
                $.inArray(word, this._minusWords) == -1 && this._minusWords.push(word);
            } else {
                this._minusWords = $.grep(this._minusWords, function(w) {
                    return w != word;
                });

            }
            this.model.update({'minus_words': this._minusWords.join(' ')});
            this.scheduleUpdateCount(this.countWord(), this.getGeo());
            this.updateChanged();
        },

        initListItems: function() {
            this.listItems = this.findBlocksInside('b-minus-words-item');
            $.each(this.listItems, $.proxy(function(i, elem) {
                elem.on('change', { id: i }, this.onCheckboxChecked, this);
            }, this));
        },

        requestWord: function() {
            var fullWord = this.fullWord(),
                allWords = [],
                items = this.listItems;
            this.listItems && $.each(this.listItems, $.proxy(function(i, item) {
                var word = item.word();
                fullWord.indexOf(word) == -1 && allWords.push(word);
            }));
            return fullWord + ' ' + allWords.join(' ');
        },

        init: function() {
            this.word  = this.model.get('key_words');
            this.data  = dataForWord[this.getGeo() + '-' + this.word] = dataForWord[this.getGeo() + '-' + this.word] || { words: [], has_more: true, loaded: false };
            this.countLoading = false;
            this.updateMinusWords();
            var data = this.getDataForWord(this.word, this.getGeo());

            data && (data.loaded = false);
            this.loadWords(this.requestWord() + (this.generalMinusWords || ''), this.getGeo());

            this.updateCount(this.word, this.getGeo());
            this.updateChanged();
        },



        onDataLoaded: function(e, data) {
            this.listData(data)
        },


        onLoadMore: function() {
            this.loadWords(this.requestWord() + (this.generalMinusWords || ''), this.getGeo());
        },

        rewriteMinusWords: function() {
            if (this.updateMinusWords()) {
                this. loadBaseFormsSchedle(this.rawMinusWords());
                this.updateChanged();
            }
        },

        updateMinusWords: function() {
            if (this.model.get('key_words') != this.word) {
                this.init();
                return false;
            } else {
                this.minusWords(this.rawMinusWords());
                this.scheduleUpdateCount(this.countWord(), this.getGeo());
                this. loadBaseFormsSchedle(this.rawMinusWords());
                this.updateChanged();
                return true;
            }
        },

        countWord: function() {
            return $.trim(this.word + ' ' + [].concat(this._minusWords).sort().join(' '));
        },



        writeCount: function(e, data) {
            this.lastCount = data.count;
            var num = data.sure ? ' <strong>' + common.number.format(data.count, {precision: 0}) + '</strong> ' : ' <img src="' + this.loadingSrc + '" style="vertical-align: middle; margin-top: -5px;"> ';
            this.elem('count').html(iget('Прогноз показов:') + num + iget('в месяц'));

        },

        changed: function() {
            return this.fullWord() != this.getOriginalWord();
        },

        fullWord: function() {
            return $.trim(this.word + ' ' + this._minusWords.join(' '));
        },

        updateChanged: function() {
            var curChanged = this.changed();
            if (curChanged !== this.lastChanged) {
                this.lastChanged = curChanged;
                this.elem('save').text(curChanged ? iget('сохранить') : iget('закрыть'))
            }
        },



        rawMinusWords: function() {
            return this.model.get('minus_words').split(' ');
        },

        getOriginalWord: function() {
            return self.originalWord;
        },

        getGeo: function() {
            return this.geo;
        }
    }, {
        getInstance: function() {
            return this.instance;
        }
    });

})(jQuery);



