(function($) {

    BEM.DOM.decl({name:'b-minus-words-popup', baseBlock: 'b-popupa'}, {
        onSetMod: {
            js: function() {
                var self = this;
                this.setMod('adjustable', 'no');
                this.setMod('direction', 'down-right');
                this.__self.instance = this;
                this.input = this.findBlockInside('b-form-input').bindTo('input', 'keyup change blur', $.proxy(this.onMinusWordsChange, this));
                this.submitBtn = this.findBlockInside({blockName: 'b-form-button', modName: 'value', modVal: 'ok'});
                this.cancelBtn = this.findBlockInside({blockName: 'b-form-button', modName: 'value', modVal: 'cancel'});
                this.submitBtn.on('click', this.onSubmit, this);
                this.cancelBtn.on('click', this.onCancel, this);
                this.__base();
                //DIRECT-17319
                var block = BEM.blocks['b-campaign-edit-block'];
                if (block) {
                    block.on('open', function(e, elem) {
                        if (elem != self && self.isShowed()) {
                            self.hide();
                        }
                    }, this);
                    self.on('show', function() {
                        block.trigger('open', self);
                    });
                }


            },

            direction: function(mode, val1, val2) {
                this.afterCurrentEvent(function() {
                    this.domElem
                        .removeClass('b-popupa_direction_' + val2)
                        .addClass('b-popupa_direction_' + val1)
                })
            }
        },

        onSubmit: function() {
            var minus = BEM.blocks['i-utils'].normalizeMinusWordsString(this.model.get('minus_words'));

            this.model.set('minus_words', minus);

            if (this.popupParams.cid && minus !== undefined) { //DIRECT-18301
                this.ajaxCheck();
            } else {
                this.onSuccess();
                this.hide();
            }

        },

        onCancel: function() {
            this.model.rollback();
            this.hide();
        },

        show: function(owner, params, onSuccess, onError, onSuccessConfirmed) {
            this.popupParams = params;
            this.limit = this.popupParams.target == 'Banners' ?  GROUP_MINUS_WORDS_LIMIT :  CAMPAIGN_MINUS_WORDS_LIMIT;
            this.ajaxCmd = this.popupParams.target == 'Banners' ? 'ajaxCheckBannersMinusWords' : 'ajaxCheckCampMinusWords';
            this.model = BEM.blocks['i-models-manager'].get(this.popupParams.target == 'Banners' ? 'campaign&banner:' + this.popupParams.bid : 'campaign', 'b-minus-words');
            this.input.val(this.model.get('minus_words')) ;
            this.onMinusWordsChange();
            this.onSuccess = $.isFunction(onSuccess) ? onSuccess : function() {};
            this.onError = $.isFunction(onError) ? onError : function() {};
            this.onSuccessConfirmed = $.isFunction(onSuccessConfirmed) ? onSuccessConfirmed : function() {};
            this.__base(owner);
        },

        ajaxCheck: function() {
            if (this.model.isFieldChanged('minus_words')) {
                this.submitBtn.setMod('disabled', 'yes');

                var self = this,
                    minusWords = this.model.get('minus_words');

                self.setMod('loading', 'yes');

                var queryData = {
                    cmd: this.ajaxCmd,
                    cid: this.popupParams.cid,
                    ulogin: this.popupParams.ulogin,
                    on_success_save: this.popupParams.on_success_save
                };
                this.popupParams.is_mediaplan && (queryData.is_mediaplan = 1);
                if (this.popupParams.bid) {
                    queryData.bids = this.popupParams.bid;
                    queryData['json_minus_words-' + this.popupParams.bid] = JSON.stringify(BEM.blocks['i-utils'].minusWordsStringToArray(minusWords));
                } else {
                    queryData['json_minus_words-0'] = JSON.stringify(minusWords);
                }
                BEM.blocks['b-minus-words'].ajaxCheck(queryData,
                    function(data) {
                        self.setMod('loading', 'no');
                        if (data.problem) {

                            if (data.can_force_save) {
                                if (confirm(data.problem)) {
                                    self.model.fixData();
                                    self.onSuccessConfirmed.call(this, data);
                                } else {
                                    self.model.rollback();
                                }
                            } else {
                                alert(data.problem);
                                self.model.rollback();
                            }

                            self.submitBtn.setMod('disabled', 'no');
                        } else {
                            self.model.fixData();
                            self.onSuccess.call(this, data);
                        }
                        self.submitBtn.setMod('disabled', 'no');
                        self.hide();
                    },
                    function() {
                        self.setMod('loading', 'no');
                        alert(iget('Ошибка запроса. Попробуйте ещё раз.'));
                        self.model.rollback();
                        self.submitBtn.setMod('disabled', 'no');
                        self.onError.call(self);
                    });
            } else {
                this.hide();
            }
        },



        onMinusWordsChange: function() {
            var value = BEM.blocks['i-utils'].normalizeMinusWordsString(this.elem('minus-words').val()),
                length = direct.utils.getMinusWordsLength(value);

            this.model.set('minus_words', value);
            this.elem('count').html(this.limit - length);
            this.setMod('error', this.limit < length ? 'yes' : 'no');
            this.submitBtn.setMod('disabled', this.limit < length ? 'yes' : 'no');
        }
    }, {
        live: false,
        getInstance: function() {
            return this.instance;
        }
    });
})(jQuery);


