(function($) {
    var NATIVE_CONTROLS = 'SELECT INPUT TEXTAREA';

    BEM.DOM.decl({name:'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.initConsts();
                this.initModel();
                this.bindEvents();
                this.initData();
            }
        },

        /**
         * Извлекает необходимые для блока константы из this.params
         * @protected
         * @returns {BEM}
         */
        initConsts: function() {
            this._modelPath = this.params.modelPath;
            this._modelName = this.params.modelName || this.__self.getName();
            return this;
        },

        /**
         * Возвращает соответствующую блоку модель
         * @protected
         * @returns {Object}
         */
        getModel: function() {
            return this.model
        },

        /**
         * Инициализирует модель, соответствующую данному блоку
         * соответствие определяется по this._modelPath и this._modelName
         * @protected
         * @returns {BEM}
        */
        initModel: function() {
            //если такой модели нет -  i-models-manager её создаст
            this.model = BEM.blocks['i-models-manager'].get(this._modelPath, this._modelName);

            return this;
        },

        /**
         * Действия, которые необходимо совершить после того как блок отобразился у пользователя
         * Реализовано в дочерних классах (если данные действия необходимы)
         * @protected
         * @returns {BEM}
         */
        onShow: function() {
            return this;
        },

        /**
         * Действия, которые необходимо совершить после закрытия блока пользователем
         * Реализовано в дочерних классах (если данные действия необходимы)
         * @protected
         * @returns {BEM}
         */
        finish: function() {
            return this;
        },

        /**
         * Модель блока кто-то изменил извне
         * Реализовано в дочерних классах (если данные действия необходимы)
         * @protected
         * @returns {BEM}
         */
        onExternalChange: function() {
            return this;
        },

        /**
         * Действия, которые необходимо совершить перед тем как блок отобразился у пользователя
         * Реализовано в дочерних классах (если данные действия необходимы)
         * @protected
         * @returns {BEM}
         */
        start: function() {
            return this;
        },

        /**
         *  Инициализируем данные в модели типа fromServer исходя из инпутов BEM-блока.
         *  Значение для поля модели  long_name берётся из инпута b-model__long-name
         * @protected
         * @returns {BEM}
         */
        initData: function() {
            var data = {};

            //заполняем модель данными пришедшими с сервера, для полей fromServer гарантировано
            //есть инпуты
            $.each(this.model.getFieldsNames('fromServer'), $.proxy(function(i, name) {
                //имя DOM-элемента по полю модели
                var elemName = this.model.getElemName(name),
                    elem = this.elem(elemName);

                if (elem && elem.length >= 1) {
                    data[name] = this.getElementValue(name);

                }
            }, this));
            this.model.initData(data, this);
            return this;
        },



        /**
         * Заполняем инпуты bem-Блока по полям модели типа toServer
         *  Значение для поля модели  long_name берётся из инпута b-model__long-name
         * @protected
         * @returns {BEM}
         */
        fillToServerFromModel: function() {
            $.each(this.model.getFieldsNames('toServer'), $.proxy(function(i, name) {
                //имя DOM-элемента по полю модели
                var elem = this.elem(this.model.getElemName(name));
                if (elem && elem.length > 0) {
                    elem.attr('type') == 'radio' || elem.val(this.model.get(name));
                }
            }, this));

            return this;
        },

        /**
         * Заполняем инпуты bem-Блока по полям модели типа input
         *  Значение для поля модели  long_name берётся из инпута b-model__long-name
         * @protected
         * @returns {BEM}
         */
        fillInputsFromModel: function() {
            $.each(this.model.getFieldsNames('input'), $.proxy(function (i, name) {
               //имя DOM-элемента по полю модели
                var elemName = this.model.getElemName(name);

               if (this.elem(elemName) && this.elem(elemName).length > 0) {
                   this.setElementValue(name, elemName, this.model.get(name))
               }
            }, this));

            return this;
        },


        /**
         * Навешиваем события, связанные с обработкой ошибок.
         * @return {BEM}
         */
        bindErrorEvents: function() {
            this.model
                .on('error-set', this.onErrorSet, this)
                .on('error-clear', this.onErrorClear, this);

            return this;
        },

        /**
         * Навешиваем обработчики на основные события
         * @protected
         * @param {Array} [fieldsNames] Массив полей модели на инпуты, сооответствующие которым нужно навесить события
         * в противном случае берутся все поля модели типа input
         * @returns {BEM}
         */
        bindEvents: function(fieldsNames) {
            this.bindErrorEvents();

            $.each(fieldsNames || this.model.getFieldsNames('input'), $.proxy(function(i, name) {
                var elemName = this.model.getElemName(name);

                if (this.elem(elemName) && this.elem(elemName).length >= 1) {
                    this.model.onField(name, 'change', {name:name}, this.onModelChanged, this);
                    this.bindChangeEvent(name)
                }
            }, this));
        },

        /**
         * Возвращаем контрол в bem-блоке соответствующий данному полю модели
         * @private
         * @param {String} name имя поля модели
         * @returns {BEM}
         */
        getControl: function(name) {
            var elemName = this.model.getElemName(name),
                elem = this.elem(elemName),
                bemBlock;

            if (!this.controls) { this.controls = {}}
            if (!this.controls[name]) {
                bemBlock = this.findBlockOn(elem, 'b-form-checkbox');
                if (bemBlock) {
                    this.controls[name] = {
                        type: 'checkbox',
                        bem: bemBlock
                    };
                    return this.controls[name];
                }

                bemBlock = this.findBlockOn(elem, 'b-form-input');

                if (bemBlock) {
                    this.controls[name] = {
                        type: 'input',
                        bem: bemBlock
                    };
                    return this.controls[name];
                }

            }

            return this.controls[name];
        },

        /**
         * Вешаем обработчики события change на поле bem-блока
         * @private
         * @param {String} name имя поля модели
         * @returns {BEM}
         */
        bindChangeEvent: function(name) {
            var self = this,
                eventName = this.model.getUpdateEvent(name) || 'change',
                elemName = this.model.getElemName(name),
                elem = this.elem(elemName);

            if (NATIVE_CONTROLS.indexOf(elem.prop('tagName')) == -1) {
                var bemElem = this.getControl(name);
                if (bemElem) {
                   bemElem.bem.on('change', function (e) {
                       self.onElementChanged(e, name);
                   })
                }

            } else {
                this.bindTo(this.model.getElemName(name), eventName, function(e) {
                    self.onElementChanged(e, name);
                })
            }

            return this;
        },

        /**
         * Обработчик события error-set
         * @protected
         * @param {Object} e событие
         * @param {Object} data
         * @returns {BEM}
         */
        onErrorSet: function(e, data) {
            for (var i = 0; i < data.fields.length; i++) {
                var fieldId = data.fields[i],
                    errorField = this.elem(this.model.getElemName(fieldId) + '-error');

                errorField = errorField.length ? errorField : this.elem('list-error');
                errorField.html(this.model.getErrorsMessagesForField(fieldId, 'errors').join('<br/>'));
            }

            return this;
        },

        /**
         * Обработчик события error-clear
         * @protected
         * @param {Object} e событие
         * @param {Object} data
         * @returns {BEM}
         */
        onErrorClear: function(e, data) {

            for (var i = 0; i < data.fields.length; i++) {
                var fieldId = data.fields[i],
                    elem = this.elem(this.model.getElemName(fieldId) + '-error');

                elem = elem.length ? elem : this.elem('list-error');
                if (elem.length > 0) {
                    elem.html('');
                }
            }

            return this;
        },

        /**
         * Обработчик события change на поле
         * @protected
         * @param {Object} e событие
         * @param {String} name имя поля модели
         * @returns {BEM}
         */
        onElementChanged: function(e, name) {

            var data = {};
            data[name] = this.getElementValue(name);
            this.model.update(data, this);
            return this;
        },


        /**
         * Валидация связанной с блоком модели
         * @protected
         * @returns {Boolean}
         */
        validate: function() {
            return this.model.validateModel();
        },

        /**
         * Обработчик события change на поле модели
         * @protected
         * @param {Object} e
         * @param {Object} data
         * @returns {BEM}
         */
        onModelChanged: function(e, data) {
            var name = e.data.name,
                elemName = this.model.getElemName(name),
                value = this.model.get(name);
            this.setElementValue(name, elemName, value);

            return this;
        },


        /**
         * Значение поля
         * todo не завершено. Возвращает значения для инпутов типа radio, checkbox и select, а также элементов BEM
         * @protected
         * @param {String} name имя поля модели
         * @returns {String|Boolean|Number}

         */
        getElementValue: function(name) {
            var elemName = this.model.getElemName(name),
                elem = this.elem(elemName);
            if (NATIVE_CONTROLS.indexOf(elem.prop('tagName')) != -1) {

                switch (elem.attr('type')) {
                    case 'radio':
                        return elem.filter(':checked').val();
                    case 'checkbox':
                        return elem.prop('checked') && !elem.prop('disabled') ? elem.val() : '';
                    default:
                        return elem.val();
                }

            }  else {

                var bemElem = this.getControl(name);

                if (!bemElem) return elem.text();

                switch (bemElem.type) {
                    case 'input':
                        return bemElem.bem.val();
                    case 'checkbox':
                        return bemElem.bem.isChecked()
                }
            }


        },


        /**
         * Устанавливает значение поля
         * @protected
         * @param {String} name имя поля модели
         * @param {String} elemName имя элемента
         * @param {String|Boolean|Number} value значение поля
         * @returns {BEM}
         */
        setElementValue: function(name, elemName, value) {
            var elem = this.elem(elemName);

            if (NATIVE_CONTROLS.indexOf(elem.prop('tagName')) != -1) {
                switch (elem.attr('type')) {
                    case 'radio':
                        elem.filter('[value=' + value + ']').prop('checked', true);
                        return this;
                    case 'checkbox':
                        elem.prop('checked', value == elem.val());
                        return this;
                    default:
                        elem.val(value);
                        return this;
                }
            } else {
                var bemElem = this.getControl(name);

                if (!bemElem) {

                    elem.text(value);

                } else {
                    switch (bemElem.type) {
                        case 'checkbox':
                            bemElem.bem.setMod('checked', value ? 'yes' : '');
                            return this;
                        case 'input':
                            bemElem.bem.val(value);
                            return this;
                    }
                }
                return this;
            }
        },

        /**
         * Возвращает значения модели типа toServer
         * @protected
         * @returns {Object}
         */
        getHiddens: function() {
            return this.model.memento(false, true, 'toServer');
        },

        //для совместимости с b-outboard-controls
        prepareToShow: function(params) {
            this.fillInputsFromModel();
        },

        provideData: function(params, callback) {

        },

        declineChange: function() {
            this.model.rollback(this);
        }

    }, {
        getText: function() {
            return '';
        },

        getButtonText: function() {
            return iget('настроить');
        }
    });
})(jQuery);
