include('../../js/jq/direct/utils.js');

BEM.DOM.decl('b-modify-user', {

    onSetMod: {

        'js': function() {
            var myPagesPropInitState = this.elem('my-pages').prop('checked'),
                params = this.params;

            this
                .bindTo('api-settings', 'submit', function(e) {
                    if (params.permission.limitsEdit) {
                        for (var m in this._methodsLimits) {
                            if (!this._methodsLimits[m] && !params.methodLimits.hasOwnProperty(m)) {
                                delete this._methodsLimits[m];
                            }
                        }
                        this.elem('json-limits-input').val(JSON.stringify(this._methodsLimits))
                    } else {
                        this.elem('json-limits-input').val(JSON.stringify({}))
                    }

                    !this._apiValidate() && e.preventDefault();
                })

                .bindTo('general-settings', 'submit', function(e) {
                    var myPagesPropCurrentState = this.elem('my-pages').prop('checked');

                    if (myPagesPropInitState != myPagesPropCurrentState) {
                        var confirmText = myPagesPropCurrentState ?
                            iget('Вы дали агентству право размещать кампании только на собственных отдельных площадках. Сохранить?') :
                            iget('Вы отменили агентству право размещать кампании только на собственных отдельных площадках. При сохранении все кампании субклиентов, показывающиеся только на собственной рекламной площадке, будут показываться на всех площадках Яндекса и РСЯ. Сохранить?');

                        confirm(confirmText) || e.preventDefault();
                    }

                    !this._generalValidate() && e.preventDefault();
                });

            params.permission.descEdit && this.findBlockOn('copy-user-data', 'b-pseudo-link').on('click', this._addDescription, this);

            if (!params.permission.limitsRead) return;

            params.methodLimits || (params.methodLimits = {});

            this._methodsLimits = $.extend({}, params.methodLimits);
            this._showLimitsLink = this.findBlockOn('show-limits', 'b-pseudo-link');
            this._limitsPopup = this.findBlockOn('limits-popup', 'b-popupa');
            this._emptyLimitsLabel = this.elem('empty-limits-label');
            this._limitsList = this.elem('limits-list');

            this._showLimitsLink.on('click', function() { this._limitsPopup.toggle(this._showLimitsLink.domElem) }, this);
            $.isEmptyObject(this._methodsLimits) && this.setMod(this._emptyLimitsLabel, 'show', 'yes');

            if (!params.permission.limitsEdit) return;

            this._limitChangeFlag = false;
            this._setButton = this.findBlockOn('method-limit-set', 'b-form-button');
            this._resetButton = this.findBlockOn('method-limit-reset', 'b-form-button');

            this._methodLimitInput = this.elem('method-limit-input');
            this._methodsSelect = this.elem('methods-select');

            this._setButton.on('click', this._setMethodLimit, this);
            this._resetButton.on('click', this._resetMethodLimit, this);

            this
                .bindTo(this._methodsSelect, 'change', function() { this._changeEditingMethod(this._methodsSelect.val()) })

                .bindTo(this._methodLimitInput, 'keypress', function() {
                    if (!this._limitChangeFlag) {
                        this._setButton.setMod('disabled', 'no');
                        this._resetButton.setMod('disabled', 'no');
                        this._limitChangeFlag = true;
                    }
                });

            this._changeEditingMethod(this.elem('methods-select').val());
        }
    },

    /**
     * Установка ограничений вызовов выбранного api метода
     * @private
     */
    _setMethodLimit: function() {
        var limit = this._methodLimitInput.val(),
            method = this._methodsSelect.val();

        if (!limit.match(/^\d+$/)) {
            alert(iget('Ограничения вызовов должны быть заданы целым числом'));
            return;
        }

        this._limitChangeFlag = false;
        this._setButton.setMod('disabled', 'yes');
        limit && (this._methodsLimits[method] = limit);

        this.setMod(this._emptyLimitsLabel, 'show', 'no');

        var item = this.findElem(this._limitsPopup.domElem, 'limits-list-item', 'method', method),
            content = method + ': ' + limit;

        if (!item.length) {
            this._limitsList.append(
                '<li class="b-modify-user__limits-list-item b-modify-user__limits-list-item_method_' + method  + '">' +
                    content +
                '</li>'
            );
        } else {
            BEM.DOM.update(item, content);
        }
    },

    /**
     * Сброс ограничений вызовов по выбранному api методу
     * @private
     */
    _resetMethodLimit: function() {
        var method = this._methodsSelect.val(),
            item = this.findElem(this._limitsPopup.domElem, 'limits-list-item', 'method', method),
            emptyFlag = true;

        this._limitChangeFlag = false;
        this._setButton.setMod('disabled', 'yes');
        this._resetButton.setMod('disabled', 'yes');
        this._methodLimitInput.val('');
        this._methodsLimits[method] && (this._methodsLimits[method] = '');

        for (var m in this._methodsLimits) {
            if (this._methodsLimits.hasOwnProperty(m) && this._methodsLimits[m]) {
                emptyFlag = false;
                break;
            }
        }
        emptyFlag && this.setMod(this._emptyLimitsLabel, 'show', 'yes');

        item.length && item.remove();
    },

    /**
     * Обработчик события выбора api метода для установки ограничений
     * @param method
     * @private
     */
    _changeEditingMethod: function(method) {
        this._limitChangeFlag = false;
        this._setButton.setMod('disabled', 'yes');
        this._methodLimitInput.val(this._methodsLimits[method] || '');
        this._resetButton.setMod('disabled', this._methodsLimits[method] ? 'no' : 'yes');
    },

    /**
     * Валидация формы общих настроек пользователя
     * @return {Boolean}
     * @private
     */
    _generalValidate: function() {
        var city = this.elem('city'),
            geoId = this.elem('geoId'),
            fio = this.elem('fio'),
            phone = this.elem('phone'),
            email = this.elem('email');

        if (this.params.permission.regionEdit) {
            if (direct.utils.isEmpty(city.val())) {
                alert(iget('Введите название города!'));
                city.focus();
                return false;
            } else if (direct.utils.isEmpty(geoId.val())) {
                alert(iget('Неправильно введено название города!'));
                city.focus();
                return false;
            }
        }

        if (!fio.val()) {
            alert(iget('Введите имя'));
            fio.focus();
            return false;
        }

        if (phone.attr('type') == 'text' && !phone.val()) {
            alert(iget('Введите телефон'));
            phone.focus();
            return false;
        }

        if (!email.val() || !direct.utils.validateEmail(email.val())) {
            alert(iget('Введите корректный e-mail'));
            email.focus();
            return false;
        }

        return true;
    },

    /**
     * Формирование поля Примечание
     * @private
     */
    _addDescription: function() {
        var desc = this.elem('descriptions'),
            phone = this.elem('phone'),
            fio = this.elem('fio'),
            email = this.elem('email'),
            notes = desc.val(),
            params = this.params;
            

        notes && (notes += '\n');

        notes += (params.login ? iget('Логин: ') + params.login + '\n' : '') +
            (params.createTime ? iget('Cоздан: ') + params.createTime + '\n' : '') +
            iget('ФИО: ') + fio.val() + '\n' + iget('Телефон: ') + phone.val() + '\n' +
            iget('E-mail: ') + email.val();

        desc.val(notes);
    },

    /**
     * Валидация формы настроек api для пользователя
     * @return {Boolean}
     * @private
     */
    _apiValidate: function() {
        if (!this.params.permission.limitsEdit) return true;

        var apiUnitsFactor = $('.b-modify-user-api-units-factor'),
            concurrentCalls = this.elem('concurrent-calls').val();

        if (apiUnitsFactor.length) {
            if (!apiUnitsFactor.val().match(/^\d+(\.\d+)?$/)) {
                alert(iget('Неверно указан коэффициент для баллов в АПИ'));
                apiUnitsFactor.focus();
                return false;
            }
        }

        if (concurrentCalls && !concurrentCalls.match(/^\d+$/)) {
            alert(iget('Кол-во одновременных вызовов должно быть задано целым числом'));
            return false;
        }

        return true;
    }
});





