(function($){

BEM.DOM.decl('b-money-meter-slider', {
    onSetMod: {
        'js': function(){
            this.initSlider();

        }
    },

    setDisabled: function(disabled) {
        this.setMod('disabled', disabled ? 'yes' : 'no');
        this.elem('slider').slider(disabled ? 'disable' : 'enable');
    },

    onSlideChange: function(func) {
        this.elem('slider').bind("slidechange", func);
    },

    setValue: function(value) {
        this.elem('slider').slider( "value" , value)
    },

    initSlider: function() {
        this.elem('slider').slider({
            min: 0,
            max: 500
        })
    },

    getMarksCount: function() {
        return this.elem('click-mark').length;
    },

    updateClickMarks: function(data) {
        this.updateMarks('click', data);
    },

    updateBudgetMarks: function(data) {
        this.updateMarks('budget', data);
    },

    updateMarks: function(type, data){
        $.each(this.elem(type + '-mark'), function(i, mark) {
            $(mark).html(data[i]);
        });
    }

}, {
    live: true
});

})(jQuery);
