(function($){
    var iModelsManager = BEM.blocks['i-models-manager'],
        iMoneyTransfer = BEM.blocks['i-money-transfer'];

    BEM.DOM.decl('b-money-transfer-wallet', {
        onSetMod: {
            'js': function(){
                var _this = this;

                this.campModels = iModelsManager.getGroup('root&campaign:*', 'b-money-transfer-campaign');

                this.rest = this.params.sum;
                this
                    .bindTo('equal', 'click', this.addEqual)
                    .bindTo('proportion', 'click', this.addProportional);

                this.onSumChangeDebounce = $.debounce(this.onSumChange, 500, this);

                $.each(this.campModels, function(i, model) {
                    model.onField('input_sum', 'change', _this.onSumChangeDebounce, _this)
                })
            }
        },

        /**
         * Считаем число выбранных моделей
         * @returns {Number}
         */
        countSelectedCamps: function() {
            var count = 0;

            $.each(this.campModels, function(i, model) {
                if (model.get('cbx')) count++;
            });

            return count;
        },

        getSelctedCampsBudget: function() {
            var budget = [];

            $.each(this.campModels, function(i, model) {
                if (model.get('cbx')) budget.push(model.get('budget'));
            });

            return budget;
        },

        onSumChange: function() {
            var rest = this.rest;
            $.each(this.campModels, function(i, model) {
                rest = rest - model.get('input_sum');
            });

            this.elem('rest').html(format_sum_of_money(this.params.currency, common.number.format(rest)))
        },

        addEqual: function() {
            var count = this.countSelectedCamps();

            if (!count) alert(iget('Не выбраны кампании для переноса'));

            var res = iMoneyTransfer.equalToCamps(this.rest, this.countSelectedCamps()),
                num = 0, _this = this;

            $.each(this.campModels, function(i, model) {
                if (model.get('to_cbx')) {
                    num++;
                    model.set('input_sum', num <= res.remains.num ? res.value + res.remains.value : res.value, _this);
                }
            });

            return this;
        },

        addProportional: function() {
            if (!this.countSelectedCamps()) {
                alert(iget('Не выбраны кампании для переноса'));

                return;
            }

            var res = iMoneyTransfer.proportionToCamps(this.rest, this.getSelctedCampsBudget()), num = 0, _this = this;

            $.each(this.campModels, function(i, model) {
                if (model.get('selected')) {
                    num++;
                    model.set('input_sum', num <= res.remains.num ? res.value[num - 1] + res.remains.value : res.value[num - 1], _this);
                }
            });
        }
    });

})(jQuery);