/**
 * Created by IntelliJ IDEA.
 * User: heliarian
 * Date: 23.08.2010
 * Time: 19:43:05
 * To change this template use File | Settings | File Templates.
 */

(function($, Lego) {
    Lego.block['b-money-transfer'] = function(params) {
        var $this = $(this),
            currency = params.currency,
            transferModel = params.transferModel,
            minTransferMoneyWithBonus = params.minTransferMoneyWithBonus,
            form = $this.find('.b-money-transfer__form'),
            wait = $this.find('.b-money-transfer__submit-wait'),
            submit = $this.find('.b-money-transfer__submit-button');

        transferModel.bind('change.type', onTypeChange);
        submit.click(onSubmit);

        if ($.browser.msie && $.browser.version.substr(0,1) < 7) fixIE6flicker(true);

        function onSubmit(e) {
            if (!check.call(this)) {
                e.preventDefault();
                return false;
            }
            //дисаблим, чтобы не было повторного нажатия
            submit.prop('disabled', true);
            setTimeout(function() {
                wait.removeClass('g-hidden')
            }, 500);
            var hiddensText = '';

            if (transferModel.type == 'all2one') {

                hiddensText += '<input type="hidden" name="transfer_to" value="' + transferModel.to + '"></input>';
                for (var cid in transferModel.fromHash) {
                    if (transferModel.fromHash[cid]) {
                        hiddensText += '<input type="hidden" name="from__' + cid + '" value="' + transferModel.fromHash[cid] + '"></input>';
                    }
                }
            } else {
                hiddensText += '<input type="hidden" name="transfer_from" value="' + transferModel.from + '"></input>';
                for (var cid in transferModel.toHash) {
                    if (transferModel.toHash[cid] * 1) {
                        hiddensText += '<input type="hidden" name="to__' + cid + '" value="' + transferModel.toHash[cid] + '"></input>';
                    }
                }
            }
            
            form
                .append(hiddensText)
                .submit();
            return true;
        }

        function check() {
            var from_camps = transferModel.getFromCampaigns();
            var to_camps = transferModel.getToCampaigns();

            if (from_camps.length == 0) {
                alert(iget('Ошибка: Выберите кампании, с которых хотите перенести средства.'));
                return false;
            }
            if (to_camps.length == 0) {
                alert(iget('Ошибка: Выберите кампании, на которые хотите перенести средства.'));
                return false;
            }
            for (var i=0; i < from_camps.length; i++) {
                if ($.inArray(from_camps[i], to_camps) != -1) {
                    alert(iget('Ошибка: Невозможно перенести средства с кампании № %s на нее же.', from_camps[i]));
                    $(document).trigger('b-money-transfer_focus', from_camps[i]);
                    return false;
                }

                var ammount = common.number.round(transferModel.getSumFrom(from_camps[i])),
                    minTransferMoney = minTransferMoneyWithBonus || get_currency(currency)['MIN_TRANSFER_MONEY'];

                if (ammount < minTransferMoney && ammount != transferModel[from_camps[i]].sum_available) {
                    alert(
                        (minTransferMoneyWithBonus ?
                            iget('Минимальная сумма для переноса с учетом скидочного бонуса') :
                            iget('Ошибка: Перевод с кампании № %s возможен на сумму не менее', from_camps[i])) +
                        ' ' + format_sum_of_money(currency, minTransferMoney));

                    $(document).trigger('b-money-transfer_focus', to_camps[0]);

                    return false;
                }

                var diff = transferModel[from_camps[i]].total - transferModel[from_camps[i]].sum_available;
                if ((transferModel[from_camps[i]].total - ammount) < diff) {
                    alert(iget('Ошибка: Остаток средств на кампании № %s не может быть меньше %s %s', from_camps[i], diff, format_currency(currency)));
                    $(document).trigger('b-money-transfer_focus', from_camps[i]);
                    return false;
                }
            };

            for (var j=0; j < to_camps.length; j++) {
                var toAgencyID = transferModel[to_camps[j]].AgencyID * 1;
                for (var i=0; i < from_camps.length; i++) {
                    var fromAgencyID = transferModel[from_camps[i]].AgencyID * 1;
                    if (fromAgencyID != toAgencyID) {
                        if (fromAgencyID && toAgencyID) {
                            alert(iget('Кампании № %s и № %s принадлежат разным агентствам. Перенос средств возможен только на кампанию того же агентства.', from_camps[i], to_camps[j]))
                        } else if (!toAgencyID) {
                            alert(iget('Перенос с кампании № %s на № %s невозможен. Перенести средства с этой кампании можно только на кампанию того же агентства.', from_camps[i], to_camps[j]))
                        } else {
                            alert(iget('Перенос с кампании № %s на № %s невозможен. Перенести средства на эту кампанию возможно только с кампании того же агентства.', from_camps[i], to_camps[i]))
                        }
                        return false;
                    }
                }
            }

            return true;
        }
        
        function onTypeChange(e) {
            var type = transferModel.type;
            $this
                .toggleClass('b-money-transfer__all2one', type == 'all2one')
                .toggleClass('b-money-transfer__one2all', type == 'one2all')
        }

        function fixIE6flicker(fix) {
            try {
                document.execCommand("BackgroundImageCache", false, fix);
            }   catch(err) { }
        }

    }
})(jQuery, window.Lego);
