/**
 * Created by IntelliJ IDEA.
 * User: heliarian
 * Date: 24.08.2010
 * Time: 15:45:11
 * To change this template use File | Settings | File Templates.
 */
(function($, Lego) {
    Lego.block['b-money-transfer__campinfo'] = function(params) {
        var $this = $(this),
        transferModel = params.transferModel,
        campsTo = $this.find('.b-money-transfer__campinfo__camps-to'),
        campsFrom = $this.find('.b-money-transfer__campinfo__camps-from'),
        campsFromCount = $this.find('.b-money-transfer__campinfo__camps-from-count'),
        campsToCount = $this.find('.b-money-transfer__campinfo__camps-to-count'),
        sum = $this.find('.b-money-transfer__campinfo__sum');

        transferModel.bind('change.transfer-to', onChangeTransfer);
        transferModel.bind('change.transfer-from', onChangeTransfer);
        transferModel.bind('change.type', onChangeTransfer);
        $(document).trigger('campinfo-init');

        function onChangeTransfer() {
            var data = transferModel.getInfoData() || {};
            campsTo.text(data.toNames || ' - ');
            campsFrom.text(data.fromNames || ' - ');
            campsFromCount.text(data.fromCount ? ' (' + data.fromCount + ')' : '');
            campsToCount.text(data.toCount ? ' (' + data.toCount + ')' : '');
            sum.text(data.sum ? format_sum_of_money(params.currency, data.sum) : ' - ');
            var hasError = false;
            if (transferModel.type == 'one2all') {
                if (transferModel.from) {
                    hasError = data.sum > transferModel[transferModel.from].sum_available;   
                }
            }
            sum.toggleClass('b-money-transfer__campinfo__sum-error', hasError)
        }
    }
})(jQuery, window.Lego);
