/**
 * Created by IntelliJ IDEA.
 * User: heliarian
 * Date: 24.08.2010
 * Time: 11:28:36
 * To change this template use File | Settings | File Templates.
 */
(function($, Lego) {
    Lego.block['b-money-transfer__from'] = function(params) {
        var $this = $(this),
            transferModel = params.transferModel,
            table = $this.find('.b-money-transfer__from-table'),
            radios = $this.find('.b-money-transfer__from__radio'),
            rows = $this.find('.b-money-transfer__from__row'),
            links = $this.find('.b-money-transfer__from__link'),
            ammounts = $this.find('.b-money-transfer__from__ammount'),
            all = $this.find('.b-money-transfer__from__all'),
            clearAll = $this.find('.b-money-transfer__from__clear-all'),
            selectAll = $this.find('.b-money-transfer__from__select-all');

        var fromData = {}, currentRowId;
        $(document).bind('b-money-transfer_focus', onFocus)
        transferModel.bind('change.type', onChangeType);
        transferModel.bind('change.transfer-to', onChangeToTransfer);
        transferModel.bind('change.transfer-from', onChangeFromTransfer);
        selectAll.click(onSelectAll);
        clearAll.click(onClearAll);
        parseData();
        setInitState();

        function onFocus(e, cid) {
            if (transferModel.type == 'all2one') {
                fromData[cid] && fromData[cid].ammount.focus()
            }
        }
        
        function onChangeFromTransfer() {
            var fromArray = transferModel.getFromCampaigns();
            for (var cid in fromData) {
                //если нет доступных средств - просто не трогаем задисабленную строку
                if (!transferModel[cid].sum_available) { continue; }
                fromData[cid].row.toggleClass('b-money-transfer__selected-row', $.inArray(cid, fromArray) != -1);
            }
        }
        
        function onChangeToTransfer() {
            var toArray = transferModel.getToCampaigns();
            for (var cid in fromData) {

                //если нет доступных средств - просто не трогаем задисабленную строку
                if (!transferModel[cid].sum_available) { continue; }
                
                fromData[cid].row.toggleClass('b-money-transfer__disabled', $.inArray(cid, toArray) != -1);
                if (transferModel.type == 'all2one') {
                    fromData[cid].ammount.prop('disabled', $.inArray(cid, toArray) != -1);
                    fromData[cid].all.prop('disabled', $.inArray(cid, toArray) != -1 );
                } else {
                    fromData[cid].radio.prop('disabled', $.inArray(cid, toArray) != -1)
                }
            }
        }

        function onChangeTransfer() {
            var toArray = transferModel.getToCampaigns();
            for (var cid in fromData) {
                fromData[cid].row.toggleClass('b-money-transfer__disabled', $.inArray(cid, toArray) != -1)
            }
            var fromArray = transferModel.getFromCampaigns();
            for (var cid in fromData) {
                fromData[cid].row.toggleClass('b-money-transfer__selected-row', $.inArray(cid, fromArray) != -1)
            }
        }

        function onChangeType() {
            if ($.browser.msie) {
                $('<tr></tr>').appendTo(table).remove();
                //DIRECT-10152
                selectAll.css('float', 'left').css('float', '')
            }
            setInitState();
        }

        function parseData() {
            $.each(radios, function(i, radio) {
                var cid = radio.value;
                fromData[cid] = {
                    row: $(rows.get(i)),
                    ammount: $(ammounts.get(i)),
                    link: $(links.get(i)),
                    all: $(all.get(i)),
                    radio: $(radios.get(i))
                }

                fromData[cid].row.bind('click', {cid: cid}, onRowClick)
                fromData[cid].all.bind('click', {cid: cid}, onAllClick)
                fromData[cid].ammount.bind('change', {cid: cid}, onAmmountChange)
                fromData[cid].ammount.bind('focus', {cid: cid}, clearZero)

            });

        };
        
        function clearZero(e) {
            var cid = e.data.cid;
            if (!(e.target.value * 1)) {
                fromData[cid].ammount.val('')
            };
        }
        
        function setInitState() {
            currentRowId = null;
            for (var cid in fromData) {
                var value  = transferModel[cid].sum_available;
                fromData[cid].ammount.val(0);
                fromData[cid].all.prop('checked', false);
                fromData[cid].radio.prop('checked', false);
                fromData[cid].row.toggleClass('b-money-transfer__selected-row', false)
                if (value) {
                    fromData[cid].ammount.prop('disabled', false);
                    fromData[cid].all.prop('disabled', false);
                    fromData[cid].radio.prop('disabled', false);
                    fromData[cid].row.toggleClass('b-money-transfer__disabled', false)
                } else {
                    fromData[cid].ammount.prop('disabled', true);
                    fromData[cid].all.prop('disabled', true);
                    fromData[cid].radio.prop('disabled', true);
                    fromData[cid].row.toggleClass('b-money-transfer__disabled', true)
                }
            }
            radios.length == 1 && select(radios.val());
        }


        function onSelectAll() {
            var changed = {}, value;
            for (var cid in fromData) {
                value  = transferModel[cid].sum_available;
                if (value && cid != transferModel.to) {
                    fromData[cid].ammount.prop('disabled', true);
                    fromData[cid].ammount.val(value);
                    fromData[cid].all.prop('checked', true);
                    changed[cid] = value;    
                }

            }
            transferModel.resetHash(changed, 'from') 
        }
        
        function onClearAll() {
            for (var cid in fromData) {
                value  = transferModel[cid].sum_available;
                if (value && cid != transferModel.to) {
                    fromData[cid].ammount.prop('disabled', false);
                    fromData[cid].ammount.val(0);
                    fromData[cid].all.prop('checked', false);
                     
                }

            }
            transferModel.clearHash('from');
        }

        function fixValue(value) {
            return common.number.roundFormated(common.number.clear(value, { fail: 0 }));
        }

        function onAllClick(e) {
            var cid = e.data.cid;
            var checked = e.target.checked,
                value = checked ? transferModel[cid].sum_available : 0;
            fromData[cid].ammount.prop('disabled', checked);
            fromData[cid].ammount.val(value);
            var changed = {};
            changed[cid] = value;
            if (checked) {
                transferModel.addToHash(changed, 'from')    
            } else {
                transferModel.deleteFromHash(changed, 'from')
            }
            
        }

        function onAmmountChange(e) {
            var cid = e.data.cid;
            var value = fixValue(e.target.value);
            value = (transferModel[cid].sum_available < value) ? transferModel[cid].sum_available : value;
            fromData[cid].ammount.val(value);
            var changed = {};
            changed[cid] = value;
            if (value) {
                transferModel.addToHash(changed, 'from')    
            } else {
                transferModel.deleteFromHash(changed, 'from')
            }
           
        }



        function onRowClick(e) {
            if (transferModel.type == 'all2one') { return; }
            var cid = e.data.cid;
            if (fromData[cid].row.hasClass('b-money-transfer__disabled')) {
                return false;
            } else {
                select(cid);
                return true;
            }
        }


        function select(cid) {
            if (currentRowId == cid) { return; }
            if (currentRowId) {
                fromData[currentRowId].row.removeClass('b-money-transfer__selected-row');
            }
            currentRowId = cid;
            transferModel.set(cid, 'from');
            fromData[currentRowId].row.addClass('b-money-transfer__selected-row');
            if (!fromData[currentRowId].radio.prop('checked')) {
                fromData[currentRowId].radio.prop('checked', true);
            }            
        }

    }
})(jQuery, window.Lego);
