/**
 * Created by IntelliJ IDEA.
 * User: heliarian
 * Date: 27.08.2010
 * Time: 10:44:41
 * To change this template use File | Settings | File Templates.
 */
(function($, Lego) {

Lego.block['b-money-transfer__search'] = function(params) {
    var $this = $(this),
        transferModel = params.transferModel,
        search  = $this.find('.b-money-transfer__search__input'),
        searchContainer = search.parents('.b-input:eq(0)'),
        clear = $this.find('.b-money-transfer__search__clear'),
        items   = $this.find('.b-money-transfer__search__item'),
        hiddenIndexes = [],
        searchIndex = [],
        searchable = [],
        lastQuery = '';
    
    items.each(function(i, item) {
        var searchableName = $(item).find('.b-money-transfer__search__searchable-name');
        var searchableNumber = $(item).find('.b-money-transfer__search__searchable-number');
        var searchableHash = {'name': searchableName.get(0), number: searchableNumber.get(0)};
        var indexHash = {
            'name': getSearchIndex(searchableName.get(0)),
            'number': getSearchIndex(searchableNumber.get(0))
        }

        searchable.push(searchableHash);
        searchIndex.push(indexHash);

    });


    $this.data('api', {
        hiddenIndexes: function(indexes, hlt) {
            if (indexes === undefined) return hiddenIndexes;

            hiddenIndexes = indexes;

            items.each(function(i) {
                if ($.inArray(i, hiddenIndexes) != -1) {
                    this.style.display = 'none';
                } else {
                    this.style.display = '';
                    searchable[i]['number'].innerHTML = hlt ? searchIndex[i]['number'].originalHTML.replace(hlt, '<span class="b-money-transfer__search__hlted">$1</span>') : searchIndex[i]['number'].originalHTML;
                    searchable[i]['name'].innerHTML = hlt ? searchIndex[i]['name'].originalHTML.replace(hlt, '<span class="b-money-transfer__search__hlted">$1</span>') : searchIndex[i]['name'].originalHTML;
                }
            });
            return this;
        }


    });

    var api = $this.data('api');

    function getSearchIndex(item) {
        if (item) {
            return {
                searchIndex: item.innerHTML.toLowerCase(),
                originalHTML: item.innerHTML
            }
        }         
    }



    clear.click(function() {
        search.val('').trigger('change');
    });

    search.bind('click change keyup', function() {
        var q = $.trim(this.value).toLowerCase(),
            hiddenIndexes = [];
        if (q == lastQuery) return;
        lastQuery = q;
        searchContainer.toggleClass('b-money-transfer__search__showclear', !!q);

        if (q) {
            var parts = q.split(/\s+/),
                hltParts = $.map(parts, function(part) { return part.replace(/(.)/g, '[$1]'); });
            var hlt = new RegExp('(' + hltParts.join('|') + ')', 'ig');
            
            for (var k = 0; k < searchIndex.length; k++) {
                var nameHidden = false, numberHidden = false;
                for (var j = 0; j < parts.length; j++) {

                    for (var type in searchIndex[k]) {
                        
                        if (searchIndex[k][type].searchIndex.indexOf(parts[j]) == -1) {
                            if (type == 'name') { nameHidden = true; } else { numberHidden = true; }
                        }
                        //прячем - только если не  нащли вхождение ни в номере, ни в названии
                        if (nameHidden && numberHidden) {
                            hiddenIndexes.push(k);
                            break;
                        }

                    };
                };
            };

            api.hiddenIndexes(hiddenIndexes, hlt);
           
        } else {
            api.hiddenIndexes([], null);
        }
    }).trigger('change');


};
})(jQuery, window.Lego);