/**
 * Created by IntelliJ IDEA.
 * User: heliarian
 * Date: 24.08.2010
 * Time: 11:28:01
 * To change this template use File | Settings | File Templates.
 */

(function($, Lego) {

    Lego.block['b-money-transfer__to'] = function(params) {
        var $this = $(this),
            transferModel = params.transferModel,
            table = $this.find('.b-money-transfer__to-table'),
            rows = $this.find('.b-money-transfer__to__row'),
            links = $this.find('.b-money-transfer__to__link'),
            names = $this.find('.b-money-transfer__to__link-name'),
            radios = $this.find('.b-money-transfer__to__radio'),
            equally = $this.find('.b-money-transfer__to__equally'),
            distribute = $this.find('.b-money-transfer__to__distribute'),
            selectAll = $this.find('.b-money-transfer__to__select-all'),
            clearAll = $this.find('.b-money-transfer__to__clear-all'),
            sums = $this.find('.b-money-transfer__to__sum'),
            toData = {}, equallyArray = [], countCids = 0, currentRowId;

        transferModel.bind('change.type', onChangeType);
        transferModel.bind('change.transfer-from', onChangeFromTransfer);
        transferModel.bind('change.transfer-to', onChangeToTransfer);
        $(document).bind('b-money-transfer_focus', onFocus);
        selectAll.click(onSelectAll);
        clearAll.click(onClearAll);
        distribute.click(function() { onDistribute() });
        parseData();
        $(document).bind('campinfo-init', setInitState);


        function onChangeFromTransfer() {
            var fromArray = transferModel.getFromCampaigns();
            for (var cid in toData) {
                var disabled = $.inArray(cid, fromArray) != -1;
                toData[cid].row.toggleClass('b-money-transfer__disabled', disabled);
                if (transferModel.type == 'all2one') {
                    toData[cid].radio.prop('disabled', disabled);
                } else {
                    toData[cid].sum.prop('disabled', disabled);
                    toData[cid].equally.prop('disabled', disabled);
                }
            }

            onDistribute(true);
        }

        function onChangeToTransfer() {
            var toArray = transferModel.getToCampaigns();
            for (var cid in toData) {
                toData[cid].row.toggleClass('b-money-transfer__selected-row', $.inArray(cid, toArray) != -1)
            }    
        }
        
        function onClearAll() {
            equallyArray = [];
            for (var cid in toData) {
                if (cid == transferModel.from) { continue; }
                toData[cid].sum.prop('disabled', false);
                toData[cid].sum.val(0);
                toData[cid].equally.prop('checked', false)
            }     
            transferModel.clearHash('to');
        }

        function setInitState(){
            equallyArray = [];
            for (var cid in toData) {
                toData[cid].sum.prop('disabled', false);
                toData[cid].sum.val(0);
                toData[cid].radio.prop('checked', false);
                toData[cid].radio.prop('disabled', false);
                toData[cid].equally.prop('checked', false);
                toData[cid].equally.prop('disabled', false);
                toData[cid].row.toggleClass('b-money-transfer__selected-row', false);
                toData[cid].row.toggleClass('b-money-transfer__disabled', false);
            }
            radios.length == 1 && select(radios.val());

            onChangeFromTransfer();
        }

        function onSelectAll() {
            equallyArray = [];
            for (var cid in toData) {
                if (cid == transferModel.from) { continue; }
                equallyArray.push(cid);
            }
            onDistribute();
        }

        function onFocus(e, cid) {
            if (transferModel.type == 'one2all') {
                toData[cid] && toData[cid].sum.focus()
            }
        }

        function onDistribute(preventAll) {
            var changed = {};

            var from = transferModel.from;

            if (from) {
                var count = equallyArray.length || countCids - +!!toData[from],
                    sum = transferModel[from].sum_available,
                    value = common.number.round(sum / count, {'roundType': 'floor'}),
                    addNum = Math.round((sum - value * count) * 100),
                    addValue = common.number.round(+value + 0.01);

            } else {
                return;
            }
            if (equallyArray.length == 0 && !preventAll) {
                var i = 0;
                for (var cid in toData) {
                    if (cid != from) {
                        changed[cid] = (i + 1 <= addNum) ? addValue : value;

                        toData[cid].sum.prop('disabled', false);
                        toData[cid].sum.val(changed[cid]);

                        i++;
                    }
                }    
            } else {
                $.each(equallyArray, function(i, cid) {
                    if (cid != from) {
                        changed[cid] = (i + 1 <= addNum) ? addValue : value;

                        toData[cid].sum.prop('disabled', '');
                        toData[cid].sum.val(changed[cid]);
                        toData[cid].equally.prop('checked', 1)

                    }
                })
            }
            transferModel.resetHash(changed, 'to')
        }

        function onChangeType() {
            
            if ($.browser.msie) {
                $('<tr></tr>').appendTo(table).remove();
                //DIRECT-10152
                distribute.css('float', 'left').css('float', '')
            }
            
            setInitState();
        }

        function parseData() {
            $.each(radios, function(i, radio) {
                var cid = radio.value;
                countCids += 1;
                toData[cid] = {
                    row: $(rows.get(i)),
                    name: names.get(i).innerHTML,
                    radio: $(radio),
                    link: $(links.get(i)),
                    equally: $(equally.get(i)),
                    sum: $(sums.get(i))
                };
                toData[cid].row.bind('click', {cid: cid}, onRowClick);
                toData[cid].equally.bind('click', {cid: cid}, onEquallyClick);
                toData[cid].sum
                    .bind('change', {cid: cid}, onSumChange)
                    .bind('focus', {cid: cid}, clearZero);

            })
        }

        function fixValue(value) {
            return common.number.roundFormated(common.number.clear(value, { fail: 0 }));
        }
        
        function clearZero(e) {
            var cid = e.data.cid;
            if (!(e.target.value * 1)) {
                toData[cid].sum.val('');    
            }
            
        }

        function onSumChange(e) {
            var cid = e.data.cid,
                input = toData[cid].sum,
                value = fixValue(input.val()),
                changed = {};

            input.val(value);
            //если была изменена одна из сумм в "поровну"
            if ($.inArray(cid, equallyArray) != -1) {
                $.each(equallyArray, function(i, cid) {
                    toData[cid].sum.val(value);
                    changed[cid] = value;
                });
                transferModel.resetHash(changed, 'to');
            } else {
                changed[cid] = value;
                if (value) {
                    transferModel.addToHash(changed, 'to');
                } else {
                    transferModel.deleteFromHash(changed, 'to');
                }
            }

            
        }

        function onEquallyClick(e) {
            var cid = e.data.cid;
            var data;
            if (!e.target.checked) {
                equallyArray.splice($.inArray(cid, equallyArray), 1);
                if (equallyArray.length == 0) {
                    toData[cid].sum.val(0);
                    setAllSumsDisabled(false);
                    transferModel.clearHash('to');
                } else {
                    toData[cid].sum.prop('disabled', true);
                    toData[cid].sum.val(0);
                    data = {}; data[cid] = 0;
                    transferModel.deleteFromHash(data, 'to')
                }
            } else {
                data = {};
                if (equallyArray.length == 0) {
                    setAllSumsDisabled(true);
                    for (var id in toData) {
                        if (id == cid) { continue; }
                        toData[id].sum.val(0);
                        data[id] = 0;
                    }
                    transferModel.deleteFromHash(data, 'to');
                } 
                equallyArray.push(cid);
                toData[cid].sum.prop('disabled', false);
                var value = toData[equallyArray[0]].sum.val() || 0;
                toData[cid].sum.val(value);
                data = {}; data[cid] = value;
                transferModel.addToHash(data, 'to');
            }
            if (equallyArray.length == 0) {
                onClearAll();
            } else {
                onDistribute();
            }
        }


        
        function setAllSumsDisabled(disabled) {
            for (var cid in toData) {
                if (cid == transferModel.from) { continue; }
                toData[cid].sum.prop('disabled', disabled);
            }    
        }


        function onRowClick(e) {
            if (transferModel.type == 'one2all') { return; }
            var cid = e.data.cid;
            if (toData[cid].row.hasClass('b-money-transfer__disabled')) {
                return false
            } else {
                select(cid);
                return true;
            }
        }

        function select(cid) {
            if (currentRowId) {
                toData[currentRowId].row.removeClass('b-money-transfer__selected-row');
            }
            currentRowId = cid;
            transferModel.set(cid, 'to');
            toData[currentRowId].row.addClass('b-money-transfer__selected-row');
            if (!toData[currentRowId].radio.prop('checked')) {
                toData[currentRowId].radio.prop('checked', true);
            }

        }
    }
})(jQuery, window.Lego);
