(function($){
    var iMoneyTransfer = BEM.blocks['i-money-transfer'];
    
    BEM.blocks['b-model'].register('b-money-transfer-campaign', {
        fields: {
            'cid': { type: 'string' },
            'selected': { type: 'flag', input: 1 },
            'sum': { type: 'number', precision: 2, fromServer: 1, toServer: 1, failValue: 0, failView: '0.00', defaultView: '' },
            'min_rest': { type: 'number', fromServer: 1 }
        }

    });
    
    BEM.DOM.decl('b-money-transfer2', {
        onSetMod: {
            'js': function(){
                var _this = this;
                this.rest = this.params.total;
                this
                    .bindTo('equal', 'click', this.addEqual)
                    .bindTo('proportion', 'click', this.addProportional);

                this.campaigns = {};
                this.updateHeaderDebounce = $.debounce(this.updateHeader, 100, this);

                this.cbxGroup = this.findBlockInside('b-checkboxes-group');

                $.each(this.elem('campaign'), function(i, campaign) {
                    campaign = $(campaign)
                    var cid = _this.getMod(campaign, 'cid'),
                        input = _this.findBlockInside(campaign, 'b-form-input'),
                        checkbox = _this.findBlockInside(campaign, 'b-form-checkbox'),
                        data = campaign[0].onclick();
                    //с сервера приходит data.sum = data.total
                    data.sum = 0;
                    input && input.on('change', { cid: cid }, _this.onInputChange, _this);
                    checkbox && checkbox.on('change', { cid: cid }, _this.onCheckboxChange, _this);

                    _this.campaigns[cid] = {
                        'model': BEM.MODEL.get('campaign:' + cid, 'b-money-transfer-campaign')
                            .initData(data)
                            .onField('selected', 'change', { cid: cid }, _this.onSelectedChanged, _this)
                            .onField('sum', 'change', { cid: cid }, _this.onSumChanged, _this),
                        'input': input,
                        'checkbox': checkbox
                    }
                });


            }
        },

        clear: function() {
            this.cbxGroup && this.cbxGroup.setAllState('');
            $.each(this.campaigns, function(i, camp) {
                camp.model.set('sum', 0);
            });

        },

        onSelectedChanged: function(e) {
            var cid = e.data.cid, campaign = this.campaigns[cid],
                selected = campaign.model.get('selected');

            if (campaign.checkbox.getMod('focused') !== 'yes') {
                campaign.checkbox.setMod('checked', selected ? 'yes' : 'no');
                !selected && campaign.input.val('');
                this.updateHeaderDebounce();
            }

            return this;
        },

        onSumChanged: function(e) {
            var cid = e.data.cid, campaign = this.campaigns[cid];
            if (campaign.input.getMod('focused') !== 'yes') {
                //пустое значение в инпуты записываем только если в модель специально записали 0 и при этом не чекнут флаг
                if (campaign.model.get('selected') || campaign.model.get('sum')) {
                    campaign.input.val(campaign.model.view('sum'));
                } else {
                    campaign.input.val('');
                }
                this.updateHeaderDebounce();
            }

            return this;
        },

        onInputChange: function(e) {
            var cid = e.data.cid,
                campaign = this.campaigns[cid];

            campaign.model.set('sum', campaign.input.val());

            this.updateHeaderDebounce();
        },

        onCheckboxChange: function(e) {
            var cid = e.data.cid,
                campaign = this.campaigns[cid],
                selected = campaign.checkbox.getMod('checked') == 'yes';

            campaign.model.set('selected', selected);
            if (!selected) campaign.model.set('sum', 0);

            this.updateHeaderDebounce();
        },

        /**
         * Считаем число выбранных моделей
         * @returns {Number}
         */
        countSelectedCamps: function() {
            var count = 0;

            $.each(this.campaigns, function(i, camp) {
                if (camp.model.get('selected')) count++;
            });

            return count;
        },

        getSumsToTransfer: function() {
            var sums = {};

            $.each(this.campaigns, function(i, camp) {
                var sum = camp.model.get('sum');

                if (camp.model.get('selected') && !!sum) {
                    sums[camp.model.get('cid')] = sum;
                }
            });

            return sums;
        },

        getSelectedCampsData: function(fieldName) {
            var data = [];

            $.each(this.campaigns, function(i, camp) {
                var model = camp.model;

                if (model.get('selected')) data.push(model.get(fieldName));
            });

            return data;
        },

        updateHeader: function() {
            var rest = this.rest;
            $.each(this.campaigns, function(i, camp) {
                if (camp.model.get('selected')) {
                    rest = rest - camp.model.get('sum');
                }
            });

            this.elem('rest').html(format_sum_of_money(this.params.currency, rest));
            this.setMod('error', rest < 0 ? 'yes' : '');
            this.trigger('change-rest', { rest: rest });
        },


        addEqual: function() {
            var count = this.countSelectedCamps();

            if (!count) alert(iget('Не выбраны кампании для переноса'));

            var res = iMoneyTransfer.equalToCamps(this.rest, this.countSelectedCamps()),
                num = 0, _this = this, model;

            $.each(this.campaigns, function(i, camp) {
                model = camp.model;
                if (model.get('selected')) {
                    num++;
                    model.set('sum', num <= res.remains.num ? res.value + res.remains.value : res.value, _this);
                }
            });

            return this;
        },

        addProportional: function() {
            if (!this.countSelectedCamps()) {
                alert(iget('Не выбраны кампании для переноса'));

                return;
            }

            var reservedData = this.getSelectedCampsData('min_rest'),
                res = iMoneyTransfer.proportionToCamps(this.rest, reservedData),
                num = 0,

                _this = this,
                model;

            $.each(this.campaigns, function(i, camp) {
                model = camp.model;
                if (model.get('selected') && reservedData.shift()) {
                    num++;
                    model.set('sum',
                        num <= res.remains.num ? res.value[num - 1] + res.remains.value : res.value[num - 1], _this);
                } else {
                    model.set('sum', 0);
                }
            });
        }
    });

})(jQuery);
