﻿BEM.DOM.decl(
    'b-multiupload',
    {
        onSetMod: {
            js: function() {

                var that = this;

                window['b-multiupload__result'] = function(result) {
                    var result = result || [],
                        hasErrors = !!(result.length > 0);
                   
                    that
                        .setMod('status', hasErrors ? 'error' : 'ok')
                        .setMod(that.elem('errmsg'), 'visible', 'no');  // hide all errors

                    if (hasErrors) {
                        // show error messages
                        $.each(result, function(i, el) {
                            that.delMod(that.elem('errmsg', 'type', el), 'visible');
                        });
                        that._refresh();
                    }
                };

                that._refresh();

                that.bindToDomElem($(that.domElem).find('form'), 'submit', function() {
                    that.setMod('status', 'loading');
                });
                
                that.bindTo('add', 'click', function(e) {
                    if (that.hasMod(e.data.domElem, 'disabled', 'yes')) {
                        return true;
                    }

                    var num = parseInt(that.getMod(e.data.domElem, 'num'), 10);
                    if (isNaN(num)) num = 0;

                    var nextItem = that.elem('item', 'num', num + 1 + '');
                    that.setMod(nextItem, 'hidden', 'no');

                    that.setMod(that.elem('add', 'num', num + ''), 'disabled', 'yes');
                    that.setMod(that.elem('remove', 'num', num + ''), 'disabled', 'yes');
                });

                that.bindTo('remove', 'click', function(e) {
                    if (that.hasMod(e.data.domElem, 'disabled', 'yes')) {
                        return true;
                    }

                    var num = parseInt(that.getMod(e.data.domElem, 'num'), 10);
                    if (isNaN(num)) num = 0;

                    var item = that.elem('item', 'num', num + '');
                    that.setMod(item, 'hidden', 'yes');

                    var prevElem = that.elem('item', 'num', (num - 1) + '');
                    that.delMod(prevElem, 'hidden').setMod(prevElem, 'hidden', 'no');
                });

            }
        },
        onElemSetMod: {
            'item': {
                'hidden': {
                    'no': function(elem) {
                        var that = this,
                            num = parseInt(that.getMod(elem, 'num'), 10);
                        if (isNaN(num)) num = 0;

                        var nextItem = that.elem('item', 'num', (num + 1) + '');
                        // если это последний элемент
                        if (nextItem.size() == 0) {
                            // задизаблить плюс, включить минус
                            that.setMod(that.elem('add', 'num', num + ''), 'disabled', 'yes');
                            that.setMod(that.elem('remove', 'num', num + ''), 'disabled', 'no');
                        } else {
                            // включить плюс обязательно
                            that.setMod(that.elem('add', 'num', num + ''), 'disabled', 'no');
                            // включить минус, только если поле не первое
                            that.setMod(that.elem('remove', 'num', num + ''), 'disabled', num != 1 ? 'no' : 'yes');
                        }
                    },
                    'yes': function(elem) {
                        var that = this,
                            num = parseInt(that.getMod(elem, 'num'), 10);
                        if (isNaN(num)) num = 0;

                        // выключить плюс и минус
                        that.setMod(that.elem('add', 'num', num + ''), 'disabled', 'yes');
                        that.setMod(that.elem('remove', 'num', num + ''), 'disabled', 'yes');

                        that.elem('input', 'num', num + '').val('');
                    }
                }
            }
        },
        _refresh: function() {
            var that = this;

            // изначально — скрыть все поля загрузки файла, кроме первого
            // заодно дёрнуть обработчики изменения модификатора
            that.elem('item').each(function(i, el) {
                that.setMod($(el), 'hidden', i == 0 ? 'no' : 'yes');
            });
            that.setMod(that.elem('add', 'num', 1), 'disabled', 'no');

            // кэшировать нельзя, необходимо для поддержки ie9
            that.findElem('input').val('');
            that.findElem('input').each(function() {
                var $this = $(this);

                $this.replaceWith($this.clone(true));
            });
        }
    },
    {}
);
