(function($) {
    //utility - вспомогательное поле
   //server - отправляется на сервер
   //serverName - имя для хранения на сервере
   //input - напрямую вводится пользователем

   BEM.blocks['b-model'].register('b-ogrn-input', {
       fields: {
           'org_details_id': {type: 'string', input: 1, fromServer: 1, toServer: 1},
           'ogrn': {type: 'string', input: 1, fromServer: 1, toServer: 1 }
       },

       validateRules: {
            'ogrn': {
                list: [
                    {
                        id: 'ogrn_format',
                        text: iget('Введен неверный ОГРН/ОГРНИП'),
                        validator : function(value) {
                            return direct.utils.validateOGRN(value)
                        },
                        condition: function() {
                            return !this.isFieldEmpty('ogrn');
                        }
                    }
                ]
            }
       }
   });


    BEM.DOM.decl({name:'b-ogrn-input', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.__base();
                this.ogrnInput = this.findBlockInside('b-form-input')
                    .on('change blur', this.onInputChange, this);

                this.model
                    .onField('org_details_id', 'change', this.onSelectChange, this)
                    .onField('ogrn', 'change', this.onOgrnExternalChange, this)
            }
        },

        onOgrnExternalChange: function() {
            this.elem('ogrn-hidden').val( this.model.get('ogrn'));
        },

        onInputChange: function() {
            var val =  this.ogrnInput.val();
            this.model.set('ogrn', val);
            if (this.ogrnInput.getMod('focused') != 'yes') {

                this.elem('ogrn-hidden').val(val);
                this.model.set('ogrn', val);
                this.model.validateModel();
            }

        },



        onSelectChange: function() {
            var ogrn_id = this.elem('org-details-id').val(),
                val = ogrn_id ? this.elem('org-details-id').find('option:selected').text() : '';
            this.setMod('mode', ogrn_id ? 'old' : 'new');

            this.ogrnInput.val(val);
            this.elem('ogrn-hidden').val(val);
            this.model.set('ogrn', val);
            this.model.validateModel();

        },

        initConsts: function() {
            this._modelPath = this.params.modelPath;
            this._modelName = 'b-ogrn-input';
        }

    });



})(jQuery);

