BEM.DOM.decl({ block: 'b-outboard-controls' }, {

    onSetMod: {
        js: function() {
            this.getInnerBlock().on('state', this._changeState, this);


            this.acceptButton = this.findBlockOn('accept-button', 'b-form-button');
            this.declineButton = this.findBlockOn('decline-button', 'b-form-button');
            this.switcher = this.findBlockOn('switcher', 'b-form-button');
            this.initPopup();
            this.acceptButton.on('click', this.accept, this);
            this.declineButton.on('click', this.decline, this);


        }
    },

    initPopup: function() {
        this.popup = this.findBlockOn('popup', 'b-popupa')
            .bindTo('close', 'click', $.proxy(this.decline, this));
    },

    getInnerBlock: function() {

        this._inner ||
            (this._inner = this.findBlockInside(this.params.innerBlockName));
        return this._inner;
    },

    accept: function() {
        var _this = this;

        this.setMod(this.elem('popup-spin'), 'visible', 'yes');
        this
            .callInnerMethod('provideData')
            .popup.hide();
    },

    decline: function() {
        this
            .callInnerMethod('declineChange')
            .popup.hide();
    },

    prepare: function() {
        this.callInnerMethod('prepareToShow');
    },

    callInnerMethod: function(method, params) {
        var inner = this.getInnerBlock();
        inner && typeof inner[method] == 'function' && inner[method](params);

        return this;
    },

    _changeState: function(e, data) {

        if (!data) {
            return false;
        }

        data.canSave ? this.acceptButton.delMod('disabled') : this.acceptButton.setMod('disabled', 'yes');
        this.trigger('canSave', data.canSave);
    },

    setAcceptButtonText: function(text) {
        this.acceptButton.setText(text);
    },

    getAcceptButtonText: function() {
        return this.acceptButton.getText();
    }

},
{
    live: function() {

        this.liveBindTo('switcher', 'leftclick', function(e) {
            e.preventDefault();
            this.prepare();
                // @todo Проблема с открытием попапа при клике на другой свитчер
            this.popup.toggle(this.switcher.domElem);

        });
    }
});
