(function($){

BEM.DOM.decl({ name: 'b-pager', modName: 'type', modVal: 'ajax' }, {

    onSetMod: {

        'js': function() {
            this.__self.liveBindTo('pages', 'click', this._onPagesClick);
        }

    },

    /**
     * Событие клика по выбранной странице
     * Перерисовывает список страниц и генерирует событие "change-page"
     * @param {Event} e
     * @private
     */
    _onPagesClick: function(e) {
        var curPage = this.elemParams($(e.target)).page;

        if (!curPage) return;

        var params = this.elemParams(this.elem('wrapper')),
            elemParams = {
                perPage: params.perPage || 5,
                showFirst: params.showFirst || false,
                showLast: params.showLast || false,
                pagerRadius: params.pagerRadius || 3,
                bannersCount: params.bannersCount,
                currentPage: curPage
            };

        BEM.DOM.update(this.domElem, BEM.HTML.build(
            $.extend({
                block: 'b-pager',
                mods: { type: 'ajax' },
                elem: 'wrapper',
                js: elemParams
            }, elemParams)),
            function() {
                this.trigger('change-page', { page: curPage });
            },
            this
        );
    }

});

BEM.HTML.decl({ name: 'b-pager', modName: 'type', modVal: 'ajax' }, {

    onBlock: function(ctx) {
        ctx
            .js(true)
            .content({ elem : 'wrapper' });
    },

    onElem: {

        'wrapper': function(ctx) {
            var perPage = +ctx.param('perPage') || 5,
                pagerRadius = +ctx.param('pagerRadius') || 3,
                totalPages = Math.ceil(+ctx.param('bannersCount') / perPage),
                currentPage = ctx.param('currentPage') ? +ctx.param('currentPage') : 1,
                leftPage = Math.max(1, currentPage - pagerRadius),
                rightPage = Math.min(totalPages, currentPage + pagerRadius),
                pagesList = [],
                json = [];

            for (var i = leftPage; i <= rightPage; i++)
                pagesList.push(i);

            // -1 разрыв диапазона страниц, заменяется многоточием
            if (ctx.param('showFirst')) {
                if (leftPage > 2) pagesList.unshift(-1);
                if (leftPage > 1) pagesList.unshift(1);
            } else if (leftPage > 1)
                pagesList.unshift(-1);

            if (ctx.param('showLast')) {
                if (rightPage < (totalPages - 1)) pagesList.push(-1);
                if (rightPage < totalPages) pagesList.push(totalPages);
            } else if (rightPage < totalPages)
                pagesList.push(-1);

            for (var i = 0; i < pagesList.length; i++ ) {
                var p = pagesList[i];

                json.push(p > 0 ?
                    {
                        elem: 'page',
                        content: p,
                        js: { page: p },
                        current: p == currentPage
                    } :
                    {
                        elem: 'hellip',
                        content: '&#8230;'
                    }
                );
            }

            ctx
                .js(true)
                .content({
                    elem: 'pages',
                    content: json
                });
        },

        'page': function(ctx) {
            ctx
                .tag('span')
                .mods( ctx.param('current') && { current: 'yes' });
        },

        'hellip': function(ctx) {
            ctx
                .tag('span');
        }
    }

});
})(jQuery);
