//Кнопка "опдатить" на странице кампаний
(function($, Lego) {
    Lego.block['b-pay-button'] = function(params) {
        var $this = $(this),
            payType = $this.find('.b-pay-button-pay-type'),
            yaMoneyButton = $this.find('.b-pay-button-ya-money-button'),
            button = $this.find('.b-pay-button-button'),
            sums = $this.find('.b-pay-button-sum');

        yaMoneyButton.click(onYaMoneyButtonClick);
        button.click(onButtonClick);
        
        function validate() {
            //группы, которые можно оплачивать вместе
            var commonGroups = ['carefree', 'self'];
            var prevGroup;
            var validSums = false;
            
            for (var i = 0; i < sums.length; i++) {
                var parent = $(sums[i]).parents('.b-campaign-list__searchable');
                if (parent && parent[0].style.display == 'none') { continue; }
                var match = sums[i].className.match(/sum_(\d+)/);
                
                var cid = match[1];
                match = sums[i].className.match(/grop-\d*_(\S+)/);
                var group = match && match[1] || '-',
                    price = common.number.clear(sums[i].value);
                    
                if (!sums[i].value) {
                    continue;
                } else if (prevGroup && prevGroup != group && ($.inArray(group, commonGroups) == -1 || $.inArray(prevGroup, commonGroups) == -1)) {
                    alert(iget('Вы не можете одновременно оплачивать кампании с разным типом обслуживания'));
                    sums[i].focus();
                    return false;
                } else if (price == 0 || isNaN(price)) {
                    alert(iget('Неправильно указана сумма в кампании №')+ cid);
                    sums[i].focus();
                    return false;
                } else {
                    validSums = true;
                }

                prevGroup = group;
            };
            
            if (!validSums) {
                alert(iget('Не указана сумма к оплате'));
                return false;
            }

            return true;

        }

        function submit() {
            try {
                yaCounter191494.reachGoal('PAY-PROF');
                yaCounter18641516.reachGoal('PAY-PROF');
            } catch(e){}

            $this.submit();
        }

        function onYaMoneyButtonClick() {
            payType.attr('name', 'yamoney_camps');
            if (validate()) {
                submit();
                return true;
            }
        }

        function onButtonClick() {
            payType.attr('name', 'money_type');
            if (validate()) {
                submit();
                return true;
            }
        }

    };


})(jQuery, window.Lego);
