include('../../js/jq/common/parse.js');
include('../../js/jq/common/inflector.js');
include('../../js/jq/direct/forecastUtils.js');


(function($, Lego) {
    Lego.block['b-pay-easy'] = function(params) {
        var curr = direct.ForecastUtils.getCurrency(),
            currObj = get_currency(curr),
            pCurr = direct.ForecastUtils.getPseudoCurrency(),
            $this = $(this),
            dailySum = +params.daily_sum || currObj.MIN_DAY_BUDGET,
            form = $this.find('.b-pay-easy__form'),
            submit = $this.find('.b-pay-easy__submit'),
            input = $this.find('.b-pay-easy__input'),
            days = $this.find('.b-pay-easy__days');
        input.change(onUpdate);
        onUpdate();

        // в Опере при нажатии энтера в поле ввода, форма сабмитится, а change не происходит
        form.submit(function(){ input.change() });

        function onUpdate() {
            var rate = curr == 'YND_FIXED' ? pCurr.rate : 1,
                sum = Math.round(input.val(function(i, v){ return common.number.clear(v, {fail: 0, precision: 2}) }).val()),
                daysVal = Math.floor(sum/(dailySum * rate));

            submit.prop('disabled', sum < rate * currObj.MIN_AUTOBUDGET || sum > currObj.MAX_AUTOBUDGET);

            daysVal = daysVal > 0 ? daysVal : +!(sum < currObj.MIN_AUTOBUDGET * rate);

            days.html((daysVal || 1) + '&nbsp;' + common.inflector.pluralizeWord([iget("день"), iget("дня"), iget("дней")], daysVal));
        }
    }
})(jQuery, window.Lego);
