(function($, Lego) { 
    
Lego.block['b-pay-form_bucks'] = function(params) {
    var $this       = $(this),
        ueInput     = $('.b-pay-form__money-input:eq(0)', $this),
        localInput  = $('.b-pay-form__money-input:eq(1)', $this),
        ueLabel     = $('.b-pay-form__money-label:eq(0)', $this),
        localLabel  = $('.b-pay-form__money-label:eq(1)', $this),
        ueLabelValue = $('.b-pay-form__money-label-value', ueLabel),
        localLabelValue = $('.b-pay-form__money-label-value', localLabel),
        currencyInput = $('.b-pay-form__currency'),
        ueCurrencyName = currencyInput.val(),
        hiddenInput = $('.b-pay-form__value', $this),
        form        = $this.closest('form'),
        uePrevValue = '', 
        localPrevValue = '',
        convRate    = params.convRate || 30;
        
    ueInput
        .blur(function() {
            var number = common.number.clear(this.value, {fail: NaN});
            if (isNaN(number)) return;
            ueInput.val(uePrevValue = common.number.roundFormated(number));
            ueLabelValue.html(uePrevValue);
        })
        .bind('keyup keypress change blur', function() {
            if (uePrevValue == this.value) return;
            uePrevValue = this.value;

            var ueValue     = common.number.clear(this.value, {fail: NaN}),
                hiddenValue = isNaN(ueValue) ? '' : ueValue,
                localValue  = isNaN(ueValue) ? '' : common.number.roundFormated(ueValue * convRate);
            localInput.val(localValue);
            localLabelValue.html(localValue);
            localPrevValue = localValue;
            removeErrors();
            hiddenInput.val(hiddenValue);
        });
    
    ueLabel.bind('click focus', function() {
        removeErrors();
        ueLabel.add(localInput).hide();
        ueInput.add(localLabel).show();
        ueInput.focus();
        currencyInput.val(ueCurrencyName);
    });
    
    localInput
        .blur(function() {
            var number = common.number.clear(this.value, {fail: NaN});
            if (isNaN(number)) return;
            localInput.val(localPrevValue = common.number.roundFormated(number, 2));
            localLabelValue.html(localPrevValue);
        })
        .bind('keyup keypress change blur', function() {
            if (localPrevValue == this.value) return;
            localPrevValue = this.value;

            var localValue  = common.number.clear(this.value, {fail: NaN}),
                hiddenValue = isNaN(localValue) ? '' : common.number.roundFormated(localValue / convRate, {precision: 6}),
                ueValue     = isNaN(localValue) ? '' : common.number.roundFormated(localValue / convRate);
            ueInput.val(ueValue);
            ueLabelValue.html(ueValue);
            uePrevValue = ueValue;
            removeErrors();
            hiddenInput.val(hiddenValue);
        });

    localLabel.bind('click focus', function() {
        removeErrors();
        localLabel.add(ueInput).hide();
        localInput.add(ueLabel).show();
        localInput.focus();
        currencyInput.val(params.currencyId);
    });
    
    
    form.submit(function() {
        var ueValue     = common.number.clear(ueInput.val(), {fail: NaN}),
            localValue  = common.number.clear(hiddenInput.val(), {fail: NaN}),
            errors      = false;
            
        if (!localValue || isNaN(localValue)) {
            addError(localInput);
            errors = true;
        }
        if (!ueValue || isNaN(ueValue)) {
            addError(ueInput);
            errors = true;
        }
        if (errors) {
            alert(iget('Неправильно указана сумма к оплате.'));
            return false;
        }
        
        return true;
    });
    
    function addError (input) {
        if ($(input).is(':visible')) $(input).parent().append($('<div class="err-bg"></div>'));
    }
    
    function removeErrors () {
        $('.err-bg').remove();
    }
    
    localLabel.add(ueLabel).closest('td').css('height', ueLabel.closest('td')[0].offsetHeight + 'px');
    ueInput.change().focus();
};
})(jQuery, window.Lego);