(function($, Lego) {

Lego.block['b-pay-form_shows'] = function(params) {
    var $this      = $(this),
        moneyInput = $('input[type=text]', $this),
        price      = $('.b-pay-form_shows-price', $this),
        total      = $('.b-pay-form_shows-total', $this),
        submit     = $('input[type=submit]', $this),

        convRate   = common.number.round(+params.convRate || 750),
        nds        = +params.nds || 0.2;

    // для баяна отображать при выставлении счета только показы (денежные упоминания убираем)
    if (location.href.indexOf('ba.yandex') !== -1) {
        $('.b-pay-form__currency-details, .b-pay-form__total-info', $this).remove();

        return;
    }

    moneyInput.bind('keyup keypress change blur', function() {
        var value     = common.number.clear(this.value, { fail: NaN }),
            priceValue = isNaN(value) ? '0' : common.number.format(value * convRate),
            totalValue  = isNaN(value) ? '0' : common.number.format(value * convRate * (1 + nds));
        price.html(priceValue);
        total.html(totalValue);
    });

    moneyInput.change();

};

})(jQuery, window.Lego);
