/*
    Блок формы оплаты рекламной кампани/рекламных услуг для профессионального/лёгкого интерфейса
 */

(function($){

BEM.DOM.decl('b-pay', {
    onSetMod: {
        'js': function(){
            var _this = this,
                nds = +this.params.nds;

            this.withoutNds = this.findBlockOn('without-nds', 'b-toggle-input');
            this.withNds = this.findBlockOn('with-nds', 'b-toggle-input');

            function clearWithFail(val){ return common.number.clear(val, {fail: ''}) }

            function calculateEasyDays(sum){
                if (_this.params.isEasy) {
                    var daysVal = Math.floor(sum / _this.params.dailySum) || 1;

                    _this.elem('easy-days')
                        .html(daysVal + '&nbsp;' + common.inflector.pluralizeWord([iget("день"), iget("дня"), iget("дней")], daysVal));
                }
            }

            calculateEasyDays(this.params.toPay);

            $.map([['without', 'with', (100 + nds) / 100], ['with', 'without', 100 / (100 + nds)]],
                function(el){
                    var current = el[0] + 'Nds',
                        another = [el[1] + 'Nds'];

                    if (_this[current] && _this[another]) {
                        _this[current]
                            .on('click', function(){ _this[another].toggle(false) })
                            .on('change', function(e, val){
                                _this[another]
                                     // чтобы change не триггерился по кругу, прокидываем флаг
                                    .set(common.number.round(clearWithFail(val) * el[2]), 1);

                                _this.afterCurrentEvent(function(){
                                    var w = clearWithFail(_this.withNds.input.val()),
                                        wo = clearWithFail(_this.withoutNds.input.val());

                                    _this.elem('nds-sum')
                                        .text(common.number.format(w && wo ? common.number.round(w - wo) : 0, { precision: 2 }));

                                    calculateEasyDays(wo);

                                })
                            });
                    }
                });

            this.domElem.submit(function(){
                var sum = +clearWithFail(_this.withoutNds.input.val()),
                    goalName = _this.params.isEasy ? 'PAY-EASY' : 'PAY-PROF',
                    payConstName = 'MIN_PAY';

                try {
                    yaCounter191494.reachGoal(goalName);
                    yaCounter18641516.reachGoal(goalName);
                } catch(e) {}

                if (sum < get_currency(_this.params.currency)[payConstName]) {
                    alert(iget('Указанная сумма меньше минимального платежа (%s).',
                        format_const(_this.params.currency, payConstName, { nds: +(_this.params.currency == 'YND_FIXED') })));
                    return false;
                }

                if (!sum) {
                    alert(iget('Неправильно указана сумма к оплате.'));
                    return false;
                }

                return true;
            });
        }
    }
}, {});

})(jQuery);

