

(function($) {
    BEM.DOM.decl({name: 'b-phrase-minus-words-popup', baseBlock: 'b-popupa'}, {
        onSetMod: {
            js: function() {
                var self = this;
                self.__self.instance = self;
                self.__base();
                self.__self.on('open', function(e, popup) {
                    if (popup != self && self.isShowed()) {
                        self.hide();
                    }
                });
                self.setDirection('down');
                self.bindTo('close', 'leftclick', function() {
                    self.hide();
                });
            },

            direction: function(mode, val1, val2) {
                this.afterCurrentEvent(function() {
                    this.domElem
                        .removeClass('b-popupa_direction_' + val2)
                        .addClass('b-popupa_direction_' + val1)
                })
            }
        },



        show: function(owner, data) {
            this.setContent(
            BEM.HTML.build([
                {
                    elem: 'phrase',
                    block: 'b-phrase-minus-words-popup',
                    content: [
                        {
                            elem: 'phrase-main',
                            tag: 'span',
                            block: 'b-phrase-minus-words-popup',
                            content: direct.utils. escapeHTML(data.key_words)
                        },
                        {
                           elem: 'phrase-minus',
                            tag: 'span',
                           block: 'b-phrase-minus-words-popup',
                           content: '&nbsp;' + direct.utils. escapeHTML(data.minus_words)
                        },
                        {
                           elem: 'phrase-auto-minus',
                           block: 'b-phrase-minus-words-popup',
                            tag: 'span',
                           content: '&nbsp;' + direct.utils. escapeHTML(data.phrase_unglued_suffix)
                        }
                    ]
                },
                data.banner_minus_words && {
                    tag: 'div',
                    elem: 'block',
                    block: 'b-phrase-minus-words-popup',
                    content: [
                        {
                            elem: 'ext-header',
                            block: 'b-phrase-minus-words-popup',
                            content: iget('Единые минус-фразы на объявления')
                        },
                        {
                            elem: 'ext-block',
                            block: 'b-phrase-minus-words-popup',
                            content: direct.utils. escapeHTML(data.banner_minus_words)
                        }
                    ]
                },
                data.camp_minus_words && {
                    tag: 'div',
                    elem: 'block',
                    block: 'b-phrase-minus-words-popup',
                    content: [
                        {
                            elem: 'ext-header',
                            block: 'b-phrase-minus-words-popup',
                            content: iget('Единые минус-фразы на кампанию')
                        },
                        {
                            elem: 'ext-block',
                            block: 'b-phrase-minus-words-popup',
                            content: direct.utils. escapeHTML(data.camp_minus_words)
                        }
                    ]
                }
            ]));
            this.__base(owner);
        }


    }, {
        getInstance: function() {
            return this.instance;
        },
        live : false
    })



})(jQuery);
