(function($){
    var iModelsManager = BEM.blocks['i-models-manager'];
BEM.DOM.decl('b-phrase-minus-words', {
    onSetMod: {
        'js': function(){
            var campModel = BEM.blocks['i-models-manager'].get('campaign', this.params.isMediaplan ? 'b-mediaplan-view' : 'b-campaign-view');

            if (campModel.get('phrases_inited')) {
                this.init();
            } else {
                campModel.on('b-phrases-list-models:init', this.init, this)
            }

        }
    },

    init: function() {
        this.model = BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-phrases-list-phrase');
        this.campMinusModel = iModelsManager.get('campaign', 'b-minus-words');
        this.bannerMinusModel = iModelsManager.get('campaign&banner:'+this.model.get('bannerId'), 'b-minus-words');

        this.debouncedChanges = $.debounce(this.onMinusWordsChanged, 300, this);
        this.bindTo('minus-switcher', 'click', this.togglePopup);

        if (!this.params.isMediaplan)  {
            this.onMinusWordsChanged();
            this.model
                .onField('phrase_unglued_suffix minus_words', 'change', this.debouncedChanges, this);
            this.campMinusModel.onField('minus_words', 'change', this.debouncedChanges, this);
        }
        //у медиапланов есть только минус-слова на баннер
        this.bannerMinusModel.onField('minus_words', 'change', this.debouncedChanges, this);
    },

    getPopup: function() {
        return this.popup || (this.popup = BEM.blocks['b-phrase-minus-words-popup'].getInstance())
    },

    togglePopup: function() {
        if (this.getPopup().isShowed()) {
            this.getPopup().hide();
        } else {
            this.getPopup().show(this.getMinusSwitcher(), {
                key_words: this.model.get('key_words'),
                banner_minus_words: this.bannerMinusModel.get('minus_words'),
                minus_words: this.model.get('minus_words') ,
                phrase_unglued_suffix: this.model.get('phrase_unglued_suffix'),
                camp_minus_words: this.campMinusModel.get('minus_words') || this.params.campMinusWords
            })
        }
    },

    getMinusSwitcher: function() {
        return this.elem('minus-switcher')
    },

    onMinusWordsChanged: function() {
        var inline = ((this.model.get('minus_words').length + this.model.get('phrase_unglued_suffix').length) < +this.model.get('phrase_minus_words_limit'));
        inline = inline && !this.bannerMinusModel.get('minus_words');
        inline = inline && !this.campMinusModel.get('minus_words');
        this.elem('minus-inline') && this.elem('minus-inline').html(BEM.HTML.build([
            this.model.get('minus_words')&& {
                elem: 'minus-inline-block',
                tag: 'span',
                block: 'b-phrases-list-phrase',
                content: this.model.get('minus_words')
            },
            this.model.get('phrase_unglued_suffix') && {
                elem: 'minus-inline-block-auto',
                tag: 'span',
                block: 'b-phrases-list-phrase',
                content: this.model.get('phrase_unglued_suffix')
            }
        ]));

        this
            .setMod('mode', inline ? 'inline' : 'popup');
    }
});

})(jQuery);
