
(function($) {
    BEM.DOM.decl({name:'b-phrases-changing-warning'}, {
        onSetMod: {
            js: function() {
                var self = this;
                self.modelName = self.params.modelName;
                self.__self.instance = self;
                self.bindEvents();
            }
        },

        bindEvents: function() {
            var self = this;
            if ($.browser.opera || direct.mobile.isAppleMobile()) {
                this.outButtons = self.findBlocksInside({blockName: 'b-form-button', modName: 'out', modVal: 'yes'});
                $.each(this.outButtons, function(i, button) {
                    button._onClick = function(e) {
                        this.isDisabled() || self.__self.saveChanges() ?
                            e.preventDefault() :
                            this.afterCurrentEvent(function() {
                                this.trigger('click');
                            });
                    }
                })
            }
            BEM.blocks['b-changing-warning'].bindEvents($.proxy(this.hasChanges, this));
        },


        hasChanges: function() {
            var editModelsGroup = BEM.blocks['i-models-manager'].getGroup('campaign&banner:*&phrase:*,campaign&banner:*&retargeting:*', this.modelName),
                hasChanges = false;

            editModelsGroup && $.each(editModelsGroup, function(i, model) {
                if (model.isChanged('toServer')) { hasChanges = true; return false; }
            });
            return hasChanges;
        },

        unbindEvents: function() {
            if ($.browser.opera || direct.mobile.isAppleMobile()) {
                BEM.blocks['b-campaign-tags'].liveUnbindFrom('edit-link', 'leftclick');

            }
            BEM.blocks['b-changing-warning'].unbindEvents();
        }
    }, {
        saveChanges: function() {
            return BEM.blocks['b-changing-warning'].saveChanges();
        },

        unbindEvents: function() {
            this.instance && this.instance.unbindEvents();
        }
    })

})(jQuery);
    

