(function($) {
    BEM.DOM.decl({name:'b-phrases-list-ctx-search-switcher' }, {
        onSetMod : {
            js: function() {
                var _this = this,
                    count = this.params.bannersCount,
                    groups = [0, 10, 50, 250, 500, 1000],
                    group = 0;

                $.each(groups, function(i, limit) {
                    var next = groups[i + 1];

                    if (count == 0) return false;
                    if (!next) {
                        group = limit;
                        return;
                    }
                    if (count > limit && count <= next) {
                        group = next;
                        return false;
                    }
                });

                this.model = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view');
                this.switcher = this.findBlockInside('b-form-radio');

                //слушаем не 'change' потому что нам надо иметь возможность откатить событие если есть несохраненные изменения
                this.switcher.bindTo('button', 'click', function(e, data) {
                    e.preventDefault();
                    if (this.getMod('disabled')) return false;

                    Lego.cp(22, 72153, 'phrases-list-ctx-search-switcher-v2.' + group + '.' + _this.params.cid);
                    _this.onToggle(this.val() == 'context' ? 'search' : 'context');

                    return false;
                });

                this.warningPopupa = this.findBlockInside({blockName: 'b-popupa', modName: 'type', modVal: 'warning'});
                this.warningPopupa.bindTo('cancel', 'click', $.proxy(this.onCancel, this));
                this.warningPopupa.bindTo('continue', 'click', $.proxy(this.onContinue, this));
                this.warningPopupa.bindTo('save', 'click', $.proxy(this.onSave, this));
            }
        },

        onContinue: function() {
            BEM.blocks['i-models-manager'].eachModel(function(i, model) {
                model.rollback();
            }, 'campaign&banner:*&phrase:*,campaign&banner:*&timetargeting:*', 'b-phrases-list-phrase');
            this.setPlace(this.tmpPlace);
            this.warningPopupa.hide();

            // DIRECT-27034 и DIRECT-26164
            $('.b-campaign-navigation-panel__save-prices')
                .bem('b-form-button')
                .setMod('disabled', 'yes')
                .elem('text').text(iget('Сохранить'))
        },

        onSave: function() {
            this.model.on('save', this.onSaveSuccess, this, {one: 1});
            BEM.blocks['i-campaign-ajax-edit'].save();
            this.warningPopupa.hide();
        },

        onSaveSuccess: function() {
            this.tmpPlace && this.setPlace(this.tmpPlace);
            delete this.tmpPlace;
        },

        onCancel: function() {
            this.warningPopupa.hide();
        },

        onToggle: function(type) {
            var changed = false;
            BEM.blocks['i-models-manager'].eachModel(function(i, model) {
                if (model.isChanged('toServer')) { changed = true; }
            }, 'campaign&banner:*&phrase:*,campaign&banner:*&timetargeting:*', 'b-phrases-list-phrase');
            if (changed) {
                this.tmpPlace = type;
                this.warningPopupa.show();
            } else {
                this.setPlace(type);
            }
        },

        setPlace: function(place) {
            this.switcher.val(place);
            this.model.set('places_strategy', place);
            direct.CampOptions.set('places_strategy', place);

        }
    });
})(jQuery);


