(function($) {
    BEM.DOM.decl({name:'b-phrases-list-group', mod: 'strategy', modVal: 'autobudget'}, {
        onSetMod : {
            js: function() {
                var self = this,
                    bId = this.params.bannerId;

                self.__base();
                self.mode = self.params.phraseMode;
                self.modelPath = 'campaign&banner:' + bId + '&phrase:*,campaign&banner:' + bId + '&retargeting:*';
                self.modelName = 'b-phrases-list-phrase';
                self.calcAutobudgetPriority();
                BEM.blocks['i-models-manager'].onGroupField(self.modelPath, self.modelName, {
                    fieldName: 'autobudgetPriority',
                    name: 'change',
                    callback: $.proxy(self.onPriorityChange, self)
                });
                self.elem('autobudget-link').length > 0 && self.bindTo('autobudget-link', 'click', this.togglePopup);
                self.onPriorityChange({}, {})
            }
        },

        getPopup: function() {
            return this.popup || (this.popup = BEM.blocks['b-phrases-list-phrase-autobudget'].getInstance())
        },



        togglePopup: function() {
            var self = this;
            if (this.getPopup().isShowed()) {
                this.popup.hide();
            } else {
                this.popup.show(this.elem('autobudget-link'), this.autobudgetPriority, function(value) {
                    self.groupSetData({'autobudgetPriority': value}, function(model) {
                        return model.get('mode') == self.mode;
                    });
                });
            }
        },

        calcAutobudgetPriority: function() {
            var self = this, firstValue;
            BEM.blocks['i-models-manager'].eachModel(function(id, model) {
                if (model.get('mode') != self.mode)  { return true; }
                self.autobudgetPriority = model.get('autobudgetPriority');
                if (!firstValue)  { firstValue = self.autobudgetPriority; }
                if (firstValue != self.autobudgetPriority) { self.autobudgetPriority = ''; return false; }
            }, this.modelPath, this.modelName);
        },


        onPriorityChange: function(e) {
            this.calcAutobudgetPriority();
            this.updateTexts(this.autobudgetPriority);
        },

        updateTexts: function(value) {
            this.elem('autobudget-text')
                .html({1: iget('низкий'), 5: iget('высокий'), 3: iget('средний')}[value] || iget('единый'));
        }
    })

})(jQuery);

