(function($) {
    BEM.DOM.decl({name:'b-phrases-list-group', modName: 'strategy', modVal: 'context'}, {
        onSetMod : {
            js: function() {
                var self = this,
                    bId = this.params.bannerId;

                self.__base();
                self.mode = self.params.phraseMode;
                self.campModel = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view');
                self.modelPath = 'campaign&banner:' + bId + '&phrase:*,campaign&banner:' + bId + '&retargeting:*';
                self.modelName = 'b-phrases-list-phrase';

                this.currency = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view').get('currency');

                BEM.blocks['i-models-manager'].onGroupField(self.modelPath, self.modelName, {
                    fieldName: 'price_context',
                    name: 'change',
                    callback: $.proxy(self.onContextPriceChanged, self)
                });

                BEM.blocks['i-models-manager'].onGroupField(self.modelPath, self.modelName, {
                    fieldName: 'autobroker',
                    name: 'change',
                    callback: $.proxy(self.onContextAutobrokerChanged, self)
                });

                BEM.blocks['i-models-manager'].onGroup(self.modelPath, self.modelName, {
                    name: 'rollback',
                    callback: $.proxy(self.onContextPriceChanged, self)
                });

                self
                    .bindTo('autobroker', 'click', self.onContextAutobrokerClick)
                    .bindTo('price-context', 'change', self.onContextPriceInput);

                self.onContextPriceChanged({}, {});
                self.onContextAutobrokerChanged({}, {});
            }
        },

        onContextAutobrokerClick: function() {
            var self = this;
            this.groupSetData({'autobroker': +self.elem('autobroker').prop('checked')}, function(model) {
                return model.get('mode') == self.mode && !model.get('is_retargeting');
            });
        },

        onContextPriceInput: function() {
            var _this = this,
                priceElem = this.elem('price-context'),
                priceVal = priceElem.val(),
                price = common.number.clear(priceVal, { fail: priceVal });

            isNaN(price) && (price = 0);

            //присваиваем назад облагороженную цену
            priceElem.val(common.number.roundFormated(price));
            this.updatePhrasePriceStyles(price);

            this.groupSetData({ price_context: price }, function(model) {
                return model.get('mode') == _this.mode;
            })
        },

        onContextPriceChanged: function(e, data) {
            if (data.source == this) { return; }
            this.elem('price-context').val('');
            this.delMod('error');
        },

        onContextAutobrokerChanged: function(e, data) {
            if (data.source == this) { return; }
            var checked = true;
            var self = this;
            BEM.blocks['i-models-manager'].eachModel(function(id, model) {
                if (model.get('mode') != self.mode) { return true; }
                var broker = model.get('autobroker') || model.get('is_retargeting');

                checked = checked && broker;
                if (!broker) { return false; }
            }, this.modelPath, this.modelName);

            this.elem('autobroker').prop('checked', checked);
        }
    })

})(jQuery);





