(function($) {
    BEM.DOM.decl({name:'b-phrases-list-group', modName: 'strategy', modVal: 'search'}, {
        onSetMod : {
            js: function() {
                var self = this,
                    bId = this.params.bannerId;

                self.__base();
                self.mode = self.params.phraseMode;
                self.modelPath = 'campaign&banner:' + bId + '&phrase:*,campaign&banner:' + bId + '&retargeting:*';
                self.modelName = 'b-phrases-list-phrase';

                this.currency = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view').get('currency');

                BEM.blocks['i-models-manager'].onGroupField(self.modelPath, self.modelName, {
                    fieldName: 'price',
                    name: 'change',
                    callback: $.proxy(self.onPriceChanged, self)
                });

                BEM.blocks['i-models-manager'].onGroupField(self.modelPath, self.modelName, {
                    fieldName: 'autobroker',
                    name: 'change',
                    callback: $.proxy(self.onAutobrokerChanged, self)
                });

                BEM.blocks['i-models-manager'].onGroup(self.modelPath, self.modelName, {
                    name: 'rollback',
                    callback: $.proxy(self.onPriceChanged, self)
                });

                self
                    .bindTo('autobroker', 'click', self.onAutobrokerClick)
                    .bindTo('price', 'change', self.onPriceInput);

                self.onPriceChanged({}, {});
                self.onAutobrokerChanged({}, {});
            }
        },


        onAutobrokerClick: function(e) {
            var self = this;

            var checked = this.elem('autobroker').prop('checked');

             if (!checked && !confirm(iget('Внимание! Выключение автоброкера может привести к повышенному расходу средств. Автоброкер всегда понижает заявленную вами максимальную цену клика.'))) {
                 e.preventDefault();
                 return;
             }

            this.groupSetData({'autobroker': +checked}, function(model) {
                return model.get('mode') == self.mode;
            })
        },


        onPriceInput: function() {
            var _this = this,
                priceElem = this.elem('price'),
                priceVal = priceElem.val(),
                price = common.number.clear(priceVal, { fail: priceVal });

            isNaN(price) && (price = 0);

            //присваиваем назад облагороженную цену
            priceElem.val(common.number.roundFormated(price));
            this.updatePhrasePriceStyles(price);

            this.groupSetData({ price: price }, function(model) {
                return model.get('mode') == _this.mode;
            })
        },

        onPriceChanged: function(e, data) {
            if (data.source == this) { return; }
            this.elem('price').val('');
            this.delMod('error');
        },

        onAutobrokerChanged: function(e, data) {
            if (data.source == this) { return; }
            var checked = true;
            BEM.blocks['i-models-manager'].eachModel(function(id, model) {
                var broker = model.get('autobroker') || model.get('is_retargeting');
                checked = checked && broker;
                if (!broker) { return false; }
            }, this.modelPath, this.modelName);
            this.elem('autobroker').prop('checked', checked);
        }
    })

})(jQuery);





