(function($) {
    var iModelManager = BEM.blocks['i-models-manager'];

    BEM.DOM.decl({name:'b-phrases-list-group'}, {
        onSetMod : {
            js: function() {
                this.bannerId = this.params.bannerId;
                this.campModel =
                    iModelManager.get('campaign', 'b-campaign-view')
                        .on('phrase-delete', this.onPhraseDeleteComplete, this)
                        .onField('places_strategy', 'change', this.adjustHeader, this);

                this.modelName = 'b-phrases-list-phrase';
            }
        },

        setParent: function(parent) {
            this.parent = parent;
            return this;
        },

        isControlsInited: function() {
            return this.controlsInited;
        },

        setControlsInited: function() {
            this.controlsInited = true;
        },

        groupSetData: function(data, condition) {
            var self  = this,
                bId = this.params.bannerId;

            var doChanges = function(data) {
                iModelManager.eachModel(function(id, model) {
                    if (!$.isFunction(condition) || condition(model) ) {
                        model.update(data, self);
                    }
                }, 'campaign&banner:' + bId + '&phrase:*,campaign&banner:' + bId + '&retargeting:*', 'b-phrases-list-phrase');
            }
            if (this.isControlsInited()) {
                doChanges(data);
            } else {
                this.parent.initGroupControls(this, data, doChanges);
            }
        },

        updatePhrasePriceStyles: function(price) {
            var curr = get_currency(iModelManager.get('campaign', 'b-campaign-view').get('currency'));

            this.delMod('error');
            if (price == '' || isNaN(price)) {
                this.setMod('error', 'yes')
            } else if (price < curr.MIN_PRICE) {
                this.setMod('error', 'yes')
            } else if (price > curr.MIN_PAY) {
                this.setMod('error', 'yes')
            }
        },

        adjustHeader: function() {
            this.phrases = this.findBlocksInside('b-phrases-list-phrase');
            if (this.phrases.length == 0) {
                this.elem('title').hide()
            }
        },

        onPhraseDeleteComplete: function(e, bannerId) {
            if (!bannerId || bannerId != this.bannerId) { return; }
            this.phrases = this.findBlocksInside('b-phrases-list-phrase');

            if (this.phrases.length == 0) {
                this.elem('title').hide();
                this.elem('edit-block').hide();
                this.elem('empty-block').removeClass('g-hidden')
            } else {
                this.phrases[this.phrases.length - 1].setLast(true);
                this.phrases[0].setFirst(true);
            }
        }
    }, {
        live: true
    })

})(jQuery);


