(function($) {
    BEM.DOM.decl({name: 'b-phrases-list-phrase-autobudget', baseBlock: 'b-popupa'}, {
        onSetMod: {
            js: function() {
                var self = this;
                self.__self.instance = self;
                self.radio = self.findBlockInside('b-form-radio');
                self.__base();
                self.__self.on('open', function(e, popup) {
                    if (popup != self && self.isShowed()) {
                        self.hide();
                    }
                });
                self.bindTo('close', 'leftclick', self.hide);
                self.radio.on('change', self.onRadioChange, this);

            }
        },

        onRadioChange: function() {
            this.changeCallback && this.changeCallback(this.radio.val());
            this.hide();
        },

        show: function(owner, startValue, changeCallback) {
            if (startValue) {
                this.radio.val(startValue).setMod('checked', 'yes');
            } else {
                this.radio.uncheckAll()
            }
            this.changeCallback = changeCallback;
            this.__self.trigger('open', this);
            this.__base(owner);
        },

        hide: function() {
            this.changeCallback = undefined;
            this.__base();
        }


    }, {
        getInstance: function() {
            return this.instance;
        },
        live: false
    })



})(jQuery);



