(function($){

BEM.DOM.decl({name: 'b-phrases-list-phrase', modName: 'page', modVal: 'mediaplan-edit'}, {
    onSetMod: {
        'js': function(){
            this.init();
            this.initPhraseCorrection();
        }
    },

    init: function() {
        this.initConsts();
        this.initModel();


        if (this.elem('popup').length) {
            this.findBlockInside('b-pseudo-link');
            var popup = this.findBlockInside('b-dropdowna').getPopup();
            popup._getUnder().domElem.css({'margin-top': '-' + $('#b-mediaplan-prices-edit__form').css('margin-top')})
        }
        //выключатель фраз в медиаплах
        this.bindTo('active-switcher', 'click', this.switchMediaPhrase);

        this.elem('radio').length > 0 && this.bindTo('radio', 'click', this.onPlaceChange);
        this.model
            .onField('place', 'change', this.onPlaceChanged, this)
    },

    switchMediaPhrase: function() {
        var active = this.model.get('active');
        this.model.set('active', !active);
        this.setMod(this.elem('active-switcher'), 'mode', !active ? 'off' : 'on')
    },

    onPlaceChanged: function() {
        var place = this.model.get('place');

        this.elem('radio', 'val', '' + place).prop('checked', true);
        this.setMod('place', this.getPlaceByVal(place));
    },

    onPlaceChange: function(e) {
        this.model.set('place', +$(e.data.domElem).val());
    }
});

})(jQuery);
