(function($){

var PRICE_PLACES = window.CONSTS.PRICE_PLACES,
    ENTRY_PLACES = window.CONSTS.ENTRY_PLACES;

BEM.DOM.decl({name: 'b-phrases-list-phrase', modName: 'page', modVal: 'mediaplan-view'}, {
    onSetMod: {
        'js': function(){
            this.init();
        }
    },

    init: function() {
        var _this = this;

        this.initConsts();
        this.initModel();
        this.actionCbx = this.findBlockOn('action-cbx', 'b-form-checkbox');
        this.actionCbx && this.actionCbx.on('change', this.onActionCbxChange, this);

        this.statusCbx = this.findBlockOn('status-cbx', 'b-form-checkbox');

        if (this.params.isFirstAid) {
            //при принятии ПП
            this.statusCbx && this.statusCbx.on('change', this.onStatusCbxChange, this);

            //инициализируем данные, необходимые для переключалки месяц/неделя
            BEM.blocks['b-forecast-switcher'].on('b-forecast-switcher:switch', this.switchPrices, this);

            if (this.statusCbx) {
                setTimeout(function() {
                    var checked;

                    if (direct.banners_selected[ _this.model.get('bannerId')] && direct.banners_selected[ _this.model.get('bannerId')].length) {
                        checked = $.inArray( _this.model.get('phraseId'), direct.banners_selected[ _this.model.get('bannerId')]) != -1 ? 0 : 1;
                    } else {
                        checked =  _this.statusCbx.getMod('checked') == 'yes' ? 1 : 0;
                    }

                    _this.setMod('state', checked ? 'enabled' : 'disabled');
                    _this.model.update({'status': checked});
                }, 1);
            }
        } else {
            //при редактировании медиапланов
            this.statusCbx && this.statusCbx.on('change', this.onStatusCbxChangeAjax, this);
        }

        this.elem('radio').length > 0 && this.bindTo('radio', 'click', this.onPlaceChange);
        this.model
            .onField('status', 'change', this.onStatusChanged, this)
            .onField('place', 'change', this.onPlaceChanged, this);
    },

    onActionCbxChange: function() {
        this.model.set('selected', this.actionCbx.getMod('checked') == 'yes' ? 1 : 0);
    },

    onStatusChanged: function() {
        this.statusCbx.setMod('checked', this.model.get('status') ? 'yes' : 'no')
    },

    onPlaceChanged: function() {
        var place = this.model.get('place');

        this.elem('radio', 'val', '' + place).prop('checked', true);
        this.setMod('place', this.getPlaceByVal(place));
    },

    onPlaceChange: function(e) {
        this.model.set('place', +$(e.data.domElem).val());
    },

    getPositionInfoByPlace: function(place) {
        var placeNames = Object.keys(PRICE_PLACES).reduce(function(obj, key) {
            obj[PRICE_PLACES[key]] = key;

            return obj;
        }, {});

        // взято из protected/PlacePrice.pm:133 set_new_place_style
        if (PRICE_PLACES.PREMIUM == place) place = ENTRY_PLACES.PREMIUM;
        if (PRICE_PLACES.FIRST == place) place = PRICE_PLACES.GUARANTEE1;
        if (PRICE_PLACES.GARANT == place) place = ENTRY_PLACES.GUARANTEE;

        // взято из protected/PlacePrice.pm:147 get_data_by_place
        return {
            PREMIUM1: { position: 'premium', positionIndex: 0 },
            PREMIUM2: { position: 'premium', positionIndex: 1 },
            PREMIUM3: { position: 'premium', positionIndex: 2 },
            PREMIUM4: { position: 'premium', positionIndex: 3 },
            GUARANTEE1: { position: 'guarantee', positionIndex: 0 },
            GUARANTEE4: { position: 'guarantee', positionIndex: 3 }
        }[placeNames[place]];
    },

    switchPrices: function(e, type) {
        var shows = this.model.get('shows');

        type =='week' && (shows /= 4.1);

        this.elem('shows').html(common.number.format(shows, {precision: 0}));

        ['pmax', 'pmax2', 'pmin', 'max', 'min'].forEach(function(name) {
            var info = this.getPositionInfoByPlace(({
                    pmax: PRICE_PLACES.PREMIUM1,
                    pmax2: PRICE_PLACES.PREMIUM2,
                    pmin: ENTRY_PLACES.PREMIUM,
                    max: PRICE_PLACES.GUARANTEE1,
                    min: ENTRY_PLACES.GUARANTEE
                })[name]),
                value = this.model.get(info.position),
                position = value ? value[info.positionIndex] : { clicks: 0, amnesty_price: 0 },
                clicks = position.clicks,
                amnestyPrice = +common.number.roundFormated(position.amnesty_price / 1e6, {fail: 0});

            type =='week' && (clicks /= 4.1);

            this.elem(name + '_budget').html(common.number.format(amnestyPrice * clicks));
            this.elem(name + '_clicks').html(common.number.format(clicks, {precision: 0}));
        }, this);
    },

    onStatusCbxChangeAjax: function() {
        if (!this.isRequestLoaded) {
            this.isRequestLoaded = 1;
            $.post('/registered/main.pl',  {
                cmd: 'ajaxChangeStatusPhrase',
                dec_id: this.model.get('phraseId'),
                mbid: this.model.get('bannerId'),
                cid: this.params.cid
            }, $.proxy(this.onAjaxPhraseStatusChanged, this));
        }
    },

    onAjaxPhraseStatusChanged: function(result) {
        this.isRequestLoaded = 0;
        if(result == 'declined' ) {
            this.setMod('state', 'disabled');
            this.model.update({'declined': 1}, this);
        } else if( result == 'new' ) {
            this.setMod('state', 'enabled');
            this.model.update({'declined': 0}, this);
        } else {
            alert(iget('Ошибка! Статус фразы не изменен.'));
        }
    },

    onStatusCbxChange: function() {
        var checked = this.statusCbx.getMod('checked') == 'yes';

        this.setMod('state', checked ? 'enabled' : 'disabled');
        this.model.update({'status': checked});
    }

});

})(jQuery);
