/*
 *   Ключевые фразы на странице медиаплана (добавить на страницу кампании)
 *
 */

(function($){

BEM.DOM.decl({name: 'b-phrases-list-phrase', modName: 'page', modVal: 'mediaplan'}, {
    onSetMod: {
        'js': function(){
            this.init();
            this.initPhraseCorrection();
        }
    },

    init: function() {
        this.initConsts();
        this.initModel();

        this.elem('radio').length > 0 && this.bindTo('radio', 'click', this.onPlaceChange);
        this.model
            .onField('status', 'change', this.onStatusChanged, this)
            .onField('place', 'change', this.onPlaceChanged, this)
    },


    switchPrices: function(e, type) {
        var value, _this = this;
        $.map(this.changedFields, function(name) {
            value = (type =='month') ? _this.model.get(name) : _this.model.get(name) / 4.1;

            if ($.inArray(name, _this.needRound2) != -1) {
                value = common.number.format(value)
            } else {
                value = common.number.format(value, {precision: 0})
            }
            _this.elem(name).html(value);
        });
    },

    getPlaceByVal: function(placeNum) {
        return window.showVCGAuction ?
            [0, 'min', 'max', 'pmin', 'pmax2', 'pmax'][placeNum] :
            [0, 'min', 'max', 'pmin', 'pmax'][placeNum];
    },


    onStatusCbxChangeAjax: function() {
        if (!this.isRequestLoaded) {
            this.isRequestLoaded = 1;
            $.post('/registered/main.pl',  {
                cmd: 'ajaxChangeStatusPhrase',
                dec_id: this.model.get('phraseId'),
                mbid: this.model.get('bannerId'),
                cid: this.params.cid
            }, $.proxy(this.onAjaxPhraseStatusChanged, this));
        }
    },

    onAjaxPhraseStatusChanged: function(result) {
        this.isRequestLoaded = 0;
        if(result == 'declined' ) {
            this.setMod('state', 'disabled');
            this.model.update({'declined': 1}, this);
        } else if( result == 'new' ) {
            this.setMod('state', 'enabled');
            this.model.update({'declined': 0}, this);
        } else {
            alert(iget('Ошибка! Статус фразы не изменен.'));
        }
    },

    onStatusCbxChange: function() {
        var checked = this.statusCbx.getMod('checked') == 'checked';
        this.setMod('state', checked ? 'enabled' : 'disabled');
        this.model.update({'status': checked});
    }
});

})(jQuery);
