(function($) {
    var KEY_WORD_LIMIT = 40,
        iModelsManager = BEM.blocks['i-models-manager'],
        pricePlaces = window.CONSTS.PRICE_PLACES,
        entryPlaces = window.CONSTS.ENTRY_PLACES,
        placeAliasesMap = {};

    placeAliasesMap[entryPlaces.GUARANTEE] = 'min';
    placeAliasesMap[pricePlaces.GUARANTEE1] = 'max';
    placeAliasesMap[pricePlaces.PREMIUM1] = 'pmax';
    window.showVCGAuction && (placeAliasesMap[pricePlaces.PREMIUM2] = 'pmax2');
    placeAliasesMap[entryPlaces.PREMIUM] = 'pmin';


    BEM.DOM.decl({name:'b-phrases-list-phrase', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.init();
                this.initPhraseCorrection();
            }
        },

        init: function() {
            this.initConsts();
            this.initModel();

            this.bindEvents(['shows', 'clicks', 'Ctr']);

            this.bannerId = this.model.get('bannerId');
            this.phraseId = this.model.get('phraseId');
            this.modelId = this.model.get('modelId');
            this.campModel = iModelsManager.get('campaign', 'b-campaign-view');
            this.campMinusModel = iModelsManager.get('campaign', 'b-minus-words');
            this.bannerMinusModel = iModelsManager.get('campaign&banner:'+this.model.get('bannerId'), 'b-minus-words');

            this.model
                .onField('is_suspended', 'change', this.onSuspendedChange, this)
                .onField('deleted', 'change', this.onPhraseDeleted, this)
                .onField('context_coverage', 'change', function() {
                    this.elem('context-coverage').html(this.model.view('context_coverage') + '%');
                }, this)
                .onField('phrase', 'change', function() {
                    this.elem('phrase-hidden').val(this.model.get('phrase'));
                }, this)
                .onField('autobroker', 'change', this.onAutobrokerChanged, this);



            this.onSuspendedChange();

            iModelsManager.onDelete(this.params.modelPath, 'b-phrases-list-phrase', this.onPhraseDeleteComplete, this);


        },

        onAutobrokerChanged: function(e, data) {
            if (!this.priceControl) this.priceControl = this.findBlockInside('b-edit-phrase-price');
            this.priceControl.onAutobrokerChanged(e, data)

        },

        onModelChanged: function(e, data){
            var name = e.data.name,
                elemName = this.model.getElemName(name),
                value = this.model.view(name);

            this.setElementValue(name, elemName, value)
        },

        onUngluedToggleChanged: function() {
            // производим действия аналогичные тем которые делались в старой версии расклейки
            var unglued = this.model.get('unglued'),
                suf = this.elem('ungluedsuffixes');

            if (!suf[0]) return;
            this.model.fixData();
            suf.toggleClass('g-hidden', !unglued);
        },

        onFixationToggleChanged: function() {
            var keyWords = this.model.get('key_words'),
                newMode = this.model.get('stopword-fixated') ? 'on' : 'off',
                oldMode =  newMode == 'off' ? 'on' : 'off';
            this.model.get('fixation') && $.map(this.model.get('fixation'), function(fix){
                var texts = { off: fix[1], on: fix[0] };
                keyWords = keyWords.replace(new RegExp('((\\s|^)' + texts[oldMode].replace(/\+/g, '\\+') + ')'), '$2' + texts[newMode]);
            });

            this.model.initField('key_words', keyWords);
            this.model.fixData();
            this.setMod(this.elem('text'), 'stopword-fixated', newMode);
            this.model.fields['key_words_short'].trigger('change');
            this.model.fields['phrase'].trigger('change');
        },

        //изменился список стоп-слов
        onFixationsListChanged: function() {
            var keyWords = this.model.get('key_words');
            this.model.get('fixation') && $.map(this.model.get('fixation'), function(fix){
                keyWords = keyWords.replace(new RegExp('((\\s|^)' + fix[1].replace(/\+/g, '\\+') + ')'), '$2' + fix[0]);
            });

            this.model.initField('key_words', keyWords);
            this.model.fixData();
            this.model.fields['key_words_short'].trigger('change');
        },

        initPhraseCorrection: function() {
            // только на странице редактирования ставок, и НЕ на странице кампании
            if (!!this.params.isEditPricesPage) {
                this.model
                    .set('unglued', 1)
                    .set('stopword-fixated', 1)
                    .onField('phrase', 'change', function() {
                        this.elem('phrase-hidden') && this.elem('phrase-hidden').val(this.model.get('phrase'))
                    }, this)
                    .onField('unglued', 'change', this.onUngluedToggleChanged, this)
                    .onField('stopword-fixated', 'change', this.onFixationToggleChanged, this);
            }

            this.model
                .onField('fixation', 'change', this.onFixationsListChanged, this)
                .onField('key_words_short', 'change', this.onKeyWordsChanged, this)

        },


        onSuspendedChange: function() {
            this.setMod('stop', this.model.get('is_suspended') ? 'yes' : 'no')
        },

        //нажата/отменена кнока "удалить"
        onPhraseDeleted: function() {
            var deleted = this.model.get('deleted'),
                text = this.model.get('is_retargeting') ?
                    iget('Условие "%s" было удалено', direct.utils.escapeHTML(this.model.get('condition_text_short'))) :
                    iget('Фраза "%s" была удалена', direct.utils.escapeHTML(this.model.get('key_words_short')));

            if (deleted) {
                var contentHtml = BEM.HTML.build([
                    {
                        tag: 'strong',
                        content: text
                    }, {
                        block: 'b-form-button',
                        type: 'button',
                        content: iget('восстановить'),
                        mods: {theme: 'simple-lite-grey', valign: 'middle', val: 'restore'}

                    }
                ]);

                BEM.DOM.update(this.elem('deleted-yes-block'), contentHtml, function() {
                    var _this = this;
                    $.each(this.findBlocksInside('deleted-yes-block', {blockName:'b-form-button', modName:'val', modVal:'restore'}),
                       function(i, btn) {
                           btn.on('click', function() {
                               _this.model.set('deleted', 0)
                           })
                       });

                }, this)
            }
            this.setMod('deleted', deleted ? 'yes' : 'no');
        },

        onKeyWordsChanged: function() {
            this.elem('key-words').length > 0 && this.elem('key-words').text(this.model.get('key_words_short'))
        },


        onPhraseDeleteComplete: function() {
            this.domElem.remove();
            this.campModel.trigger('phrase-delete', this.bannerId);

        },

        setFirst: function(first) {
            this.domElem.toggleClass('b-table__row_first', first);
        },

        setLast: function(last) {
            this.domElem.toggleClass('b-table__row_last', last);
        },

        initConsts: function() {
            this._modelPath = this.params.modelPath;
            this._modelName = 'b-phrases-list-phrase';
        },

        getPlaceByVal: function(placeNum) {
            return placeAliasesMap[placeNum];
        }
    }, {
        live: true
    });

    BEM.blocks['b-model'].register('b-phrases-list-phrase', {
        fields: {
            'status': {type: 'string', fromServer: 1},
            //приостановка фразы
            'is_suspended': {type: 'flag', input: 1, fromServer: 1, toServer: 1},
            'bannerId': {type: 'string', fromServer: 1},

            'modelId': {type: 'string', fromServer: 1},
            'phraseId': {type: 'string', fromServer: 1},
            //фраза целиком
            'phrase': {type: 'string', toServer: 1, calcValue: function() {
                return this.get('key_words') +
                    (this.get('minus_words') ? ' ' + this.get('minus_words') : '') +
                    (this.get('unglued') ? ' ' + this.get('phrase_unglued_suffix') : '');
            }},
            //минус-слова
            'minus_words': {type: 'string', input: 1, fromServer: 1, children: ['phrase', 'phrase_minus_words_length']},
            //ключевики без минусовки
            'key_words': {type: 'string', input: 1, fromServer: 1,
                children: ['phrase', 'key_words_short']
            },


            //обрезанный вариант, для отображения DIRECT-15890
            'key_words_short': {type: 'string', calcValue: function() {
                var keyWords = this.get('key_words'),
                    keyWordsArray = keyWords.split(' ');
                keyWordsArray = $.map(keyWordsArray, function(word) {
                    return word.length > KEY_WORD_LIMIT ? word.substr(0,KEY_WORD_LIMIT) + '...' : word;
                });
                return keyWordsArray.join(' ');
            }},
            //добавленные автоматически минус-слова
            'phrase_unglued_suffix': {type: 'string', fromServer: 1, children: ['phrase']},
            //добавленные автоматически стоп-слова
            'fixation': { fromServer: 1},
            //фраза была удалена
            'deleted': {type: 'flag', toServer: 1, 'default': 0},
            //включена расклейка
            'unglued': {type: 'flag', value: 0, children: ['phrase']},
            //включена фиксация по стоп-списку
            'stopword-fixated': {type: 'flag', value: 0},

            'phrase_minus_words_limit': {type: 'number', fromServer: 1},

            'is_retargeting': {type: 'flag', fromServer: 1, 'default': 0},
            'can_edit_price': {type: 'flag', fromServer: 1},
            'mode': {type: 'string', fromServer: 1, 'default': 1},
            'strategy_mode': {type: 'string', fromServer: 1, 'default': 1},
            //для автобюджетных стратегий, значение по умолчанию - 3 = средний
            'autobudgetPriority': {type: 'number', toServer: 1, fromServer: 1, input: 1, precision: 0, 'default': 3},

            'autobroker': {type: 'flag', fromServer: 1, toServer: 1},
            'larr': {type: 'string', fromServer: 1},
            'min_price': {type: 'string', fromServer: 1},
            'context_scope': {type: 'string', fromServer: 1},
            'condition_text': {type: 'string', fromServer: 1},
            'condition_text_short': {type: 'string', fromServer: 1},
            'price': {type: 'number', input: 1, precision: 2, fail: 0, 'default': 0, defaultView: '0.00', failValue: 0, failView: '0.00', fromServer: 1, toServer: 1},
            'probs': {type: 'string', fromServer: 1},
            'no_pokazometer_stat': {type: 'flag', fromServer: 1},
            'price_context': {type: 'number', input: 1, precision: 2, fail: 0, 'default': 0, defaultView: '0.00', failValue: 0, failView: '0.00', fromServer: 1, toServer: 1},
            'search_price': {type: 'number', precision: 0, 'default': 0, fail: 0, failView: 0},
            'coverage': {type: 'number', precision: 0, 'default': 0, fail: 0, failView: 0},
            'context_coverage': {type: 'number', precision: 0, 'default': 0, fail: 0, failView: 0},
            'clicks': {type: 'number', precision: 0, fromServer: 1, children: ['budget']},
            'pokazometer_data': {type: 'const', fromServer: 1},
            'Ctr': {type: 'number', precision: 2,fromServer: 1},
            'ctx_clicks': {type: 'number', precision: 0, fromServer: 1},
            'shows': {type: 'number', precision: 0, fromServer: 1},

            //данные по спецразмещению
            'premium': {type: 'array', fromServer: 1},

            //данные по позициям гарантии
            'guarantee': {type: 'array', fromServer: 1},

            //только для медиаплана
            'id0': {type: 'string', fromServer: 1, 'default': '0'},
            'old_id': {type: 'string', fromServer: 1, 'default': '0'},
            'selected': {type: 'flag'},
            'active': {type: 'flag'},
            'numword': {type: 'string', fromServer: 1},
            'budget_type': {type: 'string'},
            'place': {type: 'number', precision: 2, fromServer: 1},
            //todo @kabzon удалить после исправления прогнозатора и редактирования медиаплана
/*
            pp_ctr - phrased.premium.0.ctr
            fp_ctr - phrase.guarantee.0.ctr
            p_ctr - phrase.premium.2.ctr
            ctr - phrase.guarantee.3.ctr
            pp_clicks - phrase.premium.0.clicks
            fp_clicks - phrase.guarantee.0.clicks
            p_clicks - phrase.premium.2.clicks
            clicks - phrase.guarantee.3.clicks

            w_pmax - это phrase.weighted.premium.0.amnesty_price
            w_max - это phrase.weighted.guarantee.0.amnesty_price
            w_pmin - это phrase.weighted.premium.2.amnesty_price
            w_min - это phrase.weighted.guarantee.3.amnesty_price
*/


            /*'w_pmin': {type: 'number', precision: 2, fromServer: 1, children: ['p_budget']},
            'w_max': {type: 'number', precision: 2, fromServer: 1, children: ['fp_budget']},
            'w_min': {type: 'number', precision: 2, fromServer: 1, children: ['budget']},
            'p_ctr': {type: 'number', precision: 2, fromServer: 1},
            'fp_ctr': {type: 'number', precision: 2, fromServer: 1},
            'ctr': {type: 'number', precision: 2, fromServer: 1},
            'shows': {type: 'number', precision: 0, fromServer: 1},
            'p_clicks': {type: 'number', precision: 0, fromServer: 1, children: ['p_budget']},
            'fp_clicks': {type: 'number', precision: 0, fromServer: 1, children: ['fp_budget']},*/

            /*'p_budget': {type: 'number', precision: 2, calcValue: function() {
                return this.get('p_clicks') * this.get('w_pmin');
            }},
            'fp_budget': {type: 'number', precision: 2, calcValue: function() {
                return this.get('fp_clicks') * this.get('w_max');
            }},
            'budget': {type: 'number', precision: 2, calcValue: function() {
                return this.get('guarantee').clicks * this.get('guarantee').amnesty_price;
            }},*/
            //end todo

            'ret_cond_id': { type: 'string', fromServer: 1},
            'verdicts': { type: '', fromServer: 1 },
            'quality_score': { type: 'string', fromServer: 1 },
            'cid': { type: 'string', fromServer: 1 }
        },

        validateRules: function() {
            var currencyName = iModelsManager.get('campaign', 'b-campaign-view').get('currency'),
                currency = get_currency(currencyName);

            return {
                'price': {
                    list: [
                        { name: 'required', id: 'required', text: iget('Ставка должна быть числом') },
                        { name: 'format', id: 'format', text: iget('Ставка должна быть числом') },
                        {
                            id: 'min',
                            name: 'min',
                            value: currency.MIN_PRICE,
                            text: iget('Ставка должна быть не меньше %s', format_const(currencyName, 'MIN_PRICE'))
                        },
                        {
                            id: 'max',
                            name: 'max',
                            value: currency.MAX_PRICE,
                            text: iget('Ставка должна быть не больше %s', format_const(currencyName, 'MAX_PRICE'))
                        }
                    ],


                    condition: function() {
                        if (this.get('mode') != 'active' || !this.get('can_edit_price')) { return false; }

                        var campModel = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view');

                        return !campModel.get('is_autobudget')  &&
                            (campModel.get('strategy') != 'different_places' || (campModel.get('places_strategy') == 'search' || campModel.get('places_strategy') == 'both') && campModel.get('search_strategy') != 'stop')
                    }

                },

                'price_context': {
                    list: [
                        {name: 'required', id: 'required', text: iget('Ставка должна быть числом')},
                        {name: 'format', id: 'format', text: iget('Ставка должна быть числом')},
                        {
                            id: 'min',
                            name: 'min',
                            value: currency.MIN_PRICE,
                            text: iget('Ставка должна быть не меньше %s', format_const(currencyName, 'MIN_PRICE'))
                        },
                        {
                            id: 'max',
                            name: 'max',
                            value: currency.MAX_PRICE,
                            text: iget('Ставка должна быть не больше %s', format_const(currencyName, 'MAX_PRICE'))
                        }
                    ],


                    condition: function() {
                        if (this.get('mode') != 'active' && this.get('mode') != 'context' || !this.get('can_edit_price')) { return false; }

                        var campModel = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view');

                        return !campModel.get('is_autobudget') && (this.get('mode') == 'context' || campModel.get('strategy') == 'different_places' &&
                            (campModel.get('places_strategy') == 'context' || campModel.get('places_strategy') == 'both') ||  campModel.get('search_strategy') == 'stop')
                    }
                },

                'phrase': {
                    'list': [
                        {
                            id: 'minus-words-maxlength',
                            name: 'minus-words-maxlength',
                            validator: function(value) {
                                var length = $.trim(value).replace(/\s{2,}/g, ' ').replace(/-!/g, '-').length;

                                return length <= CAMPAIGN_MINUS_WORDS_LIMIT;
                            },
                            text: iget('Превышена допустимая длина ключевых фраз в %s символов', CAMPAIGN_MINUS_WORDS_LIMIT)
                        }
                    ]
                }
            }
        }
    });


})(jQuery);



