(function($, Lego) {
    BEM.DOM.decl({name:'b-phrases-list-sort'}, {
        onSetMod: {
            js: function() {
                this.fireSort = $.throttle(function(e, elem) {
                    this.sortFunction(elem);
                }, 1000, this);

            }
        },

        getEmptyGroup: function(elem) {
            return {
                elem: elem,
                models: {},
                blocks: {},
                ids: []
            };
        },

        addSortedGroup: function(elem) {
            var self = this, phrases, model, id;
            phrases = self.getEmptyGroup(elem);
            $.each(self.findBlocksInside($(elem), 'b-phrases-list-phrase'), function(i, block) {
               model = block.getModel();
               id = model.get('modelId');

               phrases.models[id] = model;
               phrases.ids.push(id);
               phrases.blocks[id] = block;


            });
            self.phrases.push(phrases);
        },

        buildSortGroups: function() {
            var self = this;

            this.elem('sort-group').each(function(i, elem) {
                self.addSortedGroup(elem);
            })

        },

        sortGroup: function(group, fieldName, reverse) {
            var sortedIds = group.ids,
                modelsCache = group.models;

            return sortedIds.sort(function(a, b) {
                var sortTr;
                //для турции своя лексикографическая сортировка
                if (Lego.params.locale == 'tr' && fieldName == 'phrase') {
                    sortTr = direct.utils.sortTr(modelsCache[a].get(fieldName), modelsCache[b].get(fieldName));
                    return reverse ? -sortTr : sortTr;
                }
                else {
                    if(modelsCache[a].get(fieldName) < modelsCache[b].get(fieldName))
                        return reverse ? 1 : -1;
                    else if(modelsCache[a].get(fieldName) > modelsCache[b].get(fieldName))
                        return reverse ? -1 : 1;
                }

                return 0;
            });
        },

        sortGroups: function(groups, name, toMin, strategy) {
            var sorted;
            var self = this;
            $.each(groups, function(i, group) {
                var fragment = document.createDocumentFragment();

                sorted = self.sortGroup(group, name, toMin);

                for (var j = 0; j < sorted.length; j++) {
                    group.blocks[sorted[j]].setFirst(j == 0);
                    group.blocks[sorted[j]].setLast(j == sorted.length - 1);
                    fragment.appendChild(self._getRowForSort(group.blocks[sorted[j]], strategy));
                }
                group.elem.appendChild(fragment);
            });

            return this;
        },

        /**
         * блок может быть навешен на 2 строки в разых таблицах.
         * если это так то для стратегии context возвращаем вторую строку
         * @param block
         * @param strategy
         * @returns {Object}
         */
        _getRowForSort: function(block, strategy) {
            return block.domElem.get((block.domElem.length == 2 && strategy == 'context') ? 1 : 0);
        },


        sortFunction: function(elem) {
            var name = this.getMod(elem, 'name').replace(/-/g, '_'),
                toMin = this.getMod(elem, 'sort') == 'up' || !this.hasMod(elem, 'sort'),
                strategy = this.getMod(elem, 'strategy');

            if (!this.phrases) {
                this.phrases = [];
                this.buildSortGroups();
            }

            this
                .sortGroups(this.phrases, name, toMin, strategy)
                .delMod(this.elem('sort-link'), 'sort')
                .setMod(elem, 'sort', toMin ? 'down' : 'up');
        }
    }, {
        live: function() {
            this.liveBindTo('sort-link', 'click', function(e) {
                this.fireSort(e, e.data.domElem);
          });
        }
    });
})(jQuery, window.Lego);

