/*
 * Строка "Всего" в медиапланах
 */

(function($){

var iModelManager = BEM.blocks['i-models-manager'],
    PRICE_PLACES = window.CONSTS.PRICE_PLACES,
    ENTRY_PLACES = window.CONSTS.ENTRY_PLACES;
    POSITION_CTR_CORRECTION_BY_PLACE = window.CONSTS.POSITION_CTR_CORRECTION_BY_PLACE;

BEM.DOM.decl('b-phrases-list-total', {
    onSetMod: {
        'js': function(){
            var _this = this;

            this.needRound2 = ['budget'];

            BEM.blocks['b-forecast-switcher'].on('b-forecast-switcher:switch', this.onPeriodSwitch, this);

            iModelManager.eachModel(function(i, model) {
                model
                    .onField('declined', 'change', _this.onChange, _this)
                    .onField('active', 'change', _this.onChange, _this)
                    .onField('place', 'change', _this.onSwitchPlace, _this)
            }, this.params.modelPath, 'b-phrases-list-phrase');

            this.currency = iModelManager.get('campaign', 'b-mediaplan-view').get('currency');
            this.currentType = 'month';


            this.pseudoCurrency = this.params.pseudoCurrency;
            this.isOldCurrency = this.currency == 'YND_FIXED' && this.pseudoCurrency;
            this.currencyRate = this.isOldCurrency ? this.pseudoCurrency.rate : 1;

            this.onChange();

        }
    },

    setAllBudget: function() {
        var positions = window.showVCGAuction ?
                [
                    [iget('объём трафика %s', POSITION_CTR_CORRECTION_BY_PLACE[PRICE_PLACES.PREMIUM1]), this.getSummBudget(PRICE_PLACES.PREMIUM1)],
                    [iget('объём трафика %s', POSITION_CTR_CORRECTION_BY_PLACE[PRICE_PLACES.PREMIUM2]), this.getSummBudget(PRICE_PLACES.PREMIUM2)],
                    [iget('объём трафика %s', POSITION_CTR_CORRECTION_BY_PLACE[ENTRY_PLACES.PREMIUM]), this.getSummBudget(ENTRY_PLACES.PREMIUM)],
                    [iget('объём трафика %s', POSITION_CTR_CORRECTION_BY_PLACE[PRICE_PLACES.GUARANTEE1]), this.getSummBudget(PRICE_PLACES.GUARANTEE1)],
                    [iget('объём трафика %s', POSITION_CTR_CORRECTION_BY_PLACE[ENTRY_PLACES.GUARANTEE]), this.getSummBudget(ENTRY_PLACES.GUARANTEE)]
                ] :
                [
                    [iget('объём трафика %s', POSITION_CTR_CORRECTION_BY_PLACE[PRICE_PLACES.PREMIUM1]), this.getSummBudget(PRICE_PLACES.PREMIUM1)],
                    [iget('объём трафика %s', POSITION_CTR_CORRECTION_BY_PLACE[ENTRY_PLACES.PREMIUM]), this.getSummBudget(ENTRY_PLACES.PREMIUM)],
                    [iget('объём трафика %s', POSITION_CTR_CORRECTION_BY_PLACE[PRICE_PLACES.GUARANTEE1]), this.getSummBudget(PRICE_PLACES.GUARANTEE1)],
                    [iget('объём трафика %s', POSITION_CTR_CORRECTION_BY_PLACE[ENTRY_PLACES.GUARANTEE]), this.getSummBudget(ENTRY_PLACES.GUARANTEE)]
                ],
            _this = this;

        this.elem('budget').html(
            $.map(positions, function(el) {
                    return '' +
                        el[0] + '&nbsp;&mdash; ' +
                        '<i>' +
                            '<b>' + _this.formatValue((Math.ceil((_this.currencyRate * el[1] ) * 100)) / 100, 'budget') + '</b> ' +
                            (_this.isOldCurrency ? _this.pseudoCurrency.name : format_currency(_this.currency)) +
                        '</i>';
                }).join(', ') + '.');
    },

    onSwitchPlace: function() {
        if (!this.changeTimeout) {
            this.changeTimeout = setTimeout($.proxy(this.onChange, this), 10);
        }
    },

    onPeriodSwitch: function(e, type) {
        this.currentType = type;
        this.onChange();
    },

    onChange: function() {
        this.changeTimeout = 0;
        if (this.params.mode == 'all-budget') {
            this.setAllBudget();
        } else {
            this.setAvrCtr();
            this.setSummBudget();
            this.setSummShows();
            this.setSummClicks();
        }
    },

    setAvrCtr: function() {
        var counter = 0, summ = 0, _this = this;
        iModelManager.eachModel(function(i, model) {
            if (model.get('active')) { return true }
            summ += _this.getCurrentCtr(model);
            counter++;
        }, this.params.modelPath, 'b-phrases-list-phrase');



        this.elem('ctr').html(common.number.format(counter ? common.number.round(((summ / counter ) * 100) / 100) : 0))
    },

    getCurrentCtr: function(model) {
        var positionInfo = this.getPositionInfoByPlace(model.get('place')),
            value = model.get(positionInfo.position);

        return value ? value[positionInfo.positionIndex].ctr : 0;
    },

    getPositionInfoByPlace: function(place) {
        var placeNames = Object.keys(PRICE_PLACES).reduce(function(obj, key) {
            obj[PRICE_PLACES[key]] = key;

            return obj;
        }, {});

        // взято из protected/PlacePrice.pm:133 set_new_place_style
        if (PRICE_PLACES.PREMIUM == place) place = ENTRY_PLACES.PREMIUM;
        if (PRICE_PLACES.FIRST == place) place = PRICE_PLACES.GUARANTEE1;
        if (PRICE_PLACES.GARANT == place) place = ENTRY_PLACES.GUARANTEE;

        // взято из protected/PlacePrice.pm:147 get_data_by_place
        return {
            PREMIUM1: { position: 'premium', positionIndex: 0 },
            PREMIUM2: { position: 'premium', positionIndex: 1 },
            PREMIUM3: { position: 'premium', positionIndex: 2 },
            PREMIUM4: { position: 'premium', positionIndex: 3 },
            GUARANTEE1: { position: 'guarantee', positionIndex: 0 },
            GUARANTEE4: { position: 'guarantee', positionIndex: 3 }
        }[placeNames[place]];
    },

    getCurrentClicks: function(model) {
        var positionInfo = this.getPositionInfoByPlace(model.get('place')),
            value = model.get(positionInfo.position);

        return value ? value[positionInfo.positionIndex].clicks : 0;
    },

    getSummBudget: function(place) {
        var summ = 0, _this = this;
        iModelManager.eachModel(function(i, model) {
            if (model.get('active')) { return true }
            if (!model.get('declined')) {
                summ += (_this.getForWeek('budget', _this.getCurrentBudget(model, place)));
            }
        }, this.params.modelPath, 'b-phrases-list-phrase');
        return summ;
    },

    setSummBudget: function(place) {
        this.elem('budget').html(
            this.formatValue(this.getSummBudget(place), 'budget') +
            '&nbsp;' + format_currency(this.currency) +
            (this.isOldCurrency ?
                '<br>' +
                '(&nbsp;' +
                    this.formatValue(this.getSummBudget(place) * this.currencyRate, 'budget') +
                    '&nbsp;' + this.pseudoCurrency.name +
                '&nbsp;)' :
                ''));
    },

    getCurrentBudget: function(model, place) {
        var positionInfo = this.getPositionInfoByPlace(place || model.get('place')),
            value = model.get(positionInfo.position),
            modelPositionData = value ? value[positionInfo.positionIndex] : null;

        if (!modelPositionData) return 0;

        // amnesty_price приходит в сыром виде для большей точности расчетов
        // нормализуем: для этого делим на 1e6 и округляем до 2 знаков после запятой
        return common.number.roundFormated(modelPositionData.amnesty_price / 1e6, {fail: 0}) * modelPositionData.clicks;
    },

    setSummShows: function() {
        var summ = 0,
            _this = this;
        iModelManager.eachModel(function(i, model) {
            if (model.get('active')) { return true }
            if (!model.get('declined')) {
                summ += _this.getForWeek('shows', model.get('shows'));
            }
        }, this.params.modelPath, 'b-phrases-list-phrase');

        this.elem('shows').html(this.formatValue(summ, 'shows'));
    },

    setSummClicks: function() {
        var clicks = 0,
            _this = this;

        iModelManager.eachModel(function(i, model) {
            if (model.get('active')) { return true }
            if (!model.get('declined')) {
                clicks += _this.getForWeek('clicks', _this.getCurrentClicks(model));
            }
        }, this.params.modelPath, 'b-phrases-list-phrase');

        this.elem('clicks').html(this.formatValue(clicks, 'clicks'));
    },

    formatValue: function(value, name) {
        return common.number.format(value, {precision: $.inArray(name, this.needRound2) != -1 ? 2 : 0, exponent_delimiter: '&nbsp;'})
    },

    quickRound: function(name, value) {
        if ($.inArray(name, this.needRound2) != -1) {
            value = common.number.round(value)
        } else {
            value = common.number.round(value, { precision: 0 })
        }

        return value;
    },

    getForWeek: function(name, value) {

        return this.quickRound(name, this.currentType == 'week' ? value / 4.1 : value);
    }
});

})(jQuery);
