(function($, Lego) {

    /*
     * Список ключевых фраз/категорий/условий ретаргетинга для конкретного баннера
     * Используется на:
     *  * страница просмотра кампании
     *  * страница просмотра медиаплана
     *  * второй шаг создания/редактирования/мультиредактирования баннера/медиаплана
     */
    BEM.DOM.decl({name:'b-phrases-list'}, {
        onSetMod: {
            js: function() {
                var self = this;
                //прокидываем пришедшую с сервера статистику для условий ретаргетинга
                self.bannerModel =
                    BEM.blocks['i-models-manager'].get('campaign&banner:' + this.params.bid, 'b-banners-list-banner')
                        .on('constructor-update', this.updatePhrasesList, this);

                self.campModel = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view');
                self.delMod('paranja');
                self.campModel.trigger('b-phrases-list:init');
                //Горизонтальный вид статистики. Для него нужна подстветка.
                self.isNewBids = self.params.is_new_bids;

                this.initPhrases();
                this.bindEvents();
            }
        },

        //Инициализация лего-блоков до bem'овской (с классом g-js)
        initOldBlock: function(elem) {
            if (!elem) { return; }
            var block = $(elem),
                params = elem.onclick ? elem.onclick() : {},
                name = params.name || '',
                init = Lego.block[name];
            if (init && !block.data(name)) {
                init.call(block, params);
                block
                    .data(name, true)
                    .addClass(name + '_js_inited');
            }
        },

        initPhrases: function() {
            var self = this, length = self.elem('phrase').length;
            self.findBlockOn('sort', 'b-phrases-list-sort');
            //блоков b-phrases-list-group может быть несколько!
            self.groups = self.findBlocksOn('group', 'b-phrases-list-group');
            self.groups && self.groups.length > 0 && $.map(self.groups, function(group) {
                return group.setParent(self);
            });

            self.phrasesBlocks = {};
            self.elem('phrase').each(function(i, block) {
                var $block = $(block);
                setTimeout((function(block, i){
                    return function() {
                        var phraseBlock = self.findBlockOn(block, 'b-phrases-list-phrase');
                        self.phrasesBlocks[phraseBlock.model.path()] = block;
                        if (self.params.page == 'info' && !self.params.cant_edit_text) {
                            self.findBlockInside(block, 'b-edit-phrase-keywords');
                        }
                        //для горизонтальной статистики инициализируем подсветку
                        if (self.isNewBids) {
                            self.initOldBlock(block.find('.b-phrases-list__price-hilite')[0]);
                        }
                        if (i == length - 1) {
                            self.delMod('paranja');
                        }
                    }
                })($block, i), 10);
            });
        },


        updatePhrasesList: function(e, callbacks) {
            var _this = this;
            if (this.inited) {
                $.each(this.phrasesBlocks, function(pid, block) {
                    if (typeof callbacks[pid] == 'function') {
                        callbacks[pid]();
                    }
                });
                return;
            }
            this.setMod('paranja', 'yes');

            $.each(this.phrasesBlocks, function(pid, block) {
                var editPhraseAutobroker = _this.findBlockInside(block, 'b-edit-phrase-autobroker')
                editPhraseAutobroker && editPhraseAutobroker.onAutobrokerChanged();
                $.map(['b-edit-phrase-autobroker', 'b-edit-phrase-price'], function(el){
                    _this.findBlocksInside(block, el)
                });
                if (typeof callbacks[pid] == 'function') {
                    callbacks[pid]();
                }
            });
            $.map(this.groups, function(group) {
                group.setControlsInited();
            });
            this.inited = true;
            this.delMod('paranja');
        },


        initGroupControls: function(group, data, callback) {
            var _this = this;
            this.setMod('paranja', 'yes');
            $.map(['b-edit-phrase-autobroker', 'b-edit-phrase-price'], function(el){
                _this.findBlocksInside(group.domElem, el)
            });
            group.setControlsInited();
            this.delMod('paranja');
            callback(data);
        },

        bindEvents: function() {

        }
    });
})(jQuery, window.Lego);
