include('../b-phrases-list.js');
//todo - кажется утратило актуальность
(function($, Lego) {
var phrasesList = Lego.block['b-phrases-list'];

Lego.block['b-phrases-list__pager'] = function(params) {
    var $this = $(this),
        models = params.models,
        page = params.page,
        $prev = $this.find('.b-phrases-list__pager_prev'),
        $next = $this.find('.b-phrases-list__pager_next'),
        $num = $this.find('.b-phrases-list__pager_num');

    models.bind('changes.continue', onContinue);

    $prev.click(onPrevClick);
    $next.click(onNextClick);
    $num.click(onNumClick);

    function onContinue(data) {
        if (data.source == $this) {
            location.href = data.href;
        }
    }

    function onNumClick(e) {
        e.preventDefault();
        models.trigger('changes.check', {source: $this, page: $(this).text(), href: this.href});
        return false;
    }

    function onNextClick(e) {
        e.preventDefault();
        models.trigger('changes.check', {source: $this, page: page + 1, href: this.href});
        return false;
    }

    function onPrevClick(e) {
        e.preventDefault();
        models.trigger('changes.check', {source: $this, page: page - 1, href: this.href});
        return false;
    }
};
})(jQuery, window.Lego);