(function($, Lego) {
    Lego.block['b-phrases-list__price-hilite'] = function(params) {
        var model = BEM.blocks['i-models-manager'].get(params.modelPath, 'b-phrases-list-phrase'),
            $this = $(this),
            $prices = $this.find('.b-phrases-list__price-hilite__num');

        model.onField('price', 'change', updatePriceView);
        model.onInitData(updatePriceView);

        function updatePriceView() {

            var brokerResponse = direct.autobroker.calcPrice(
                    model.get('price'),
                    model.get('guarantee'),
                    model.get('premium'),
                    model.get('larr'),
                    model.get('min_price'),
                    sum_rest, day_budget, spent_today, strategy,
                    autobudget, autobudget_bid,
                    params.timetarget_coef
                ),
                PRICE_PLACES = window.PRICE_PLACES,
                ENTRY_PLACES = window.ENTRY_PLACES,
                PLACE_NAMES = Object.keys(PRICE_PLACES).reduce(function(obj, key) {
                    obj[PRICE_PLACES[key]] = key;

                    return obj;
                }, {}),
                typeMap = {
                    GUARANTEE1: 'max',
                    PREMIUM1: 'pmax',
                    PREMIUM2: 'pmax2',
                },
                placeName;

            typeMap[PLACE_NAMES[ENTRY_PLACES.PREMIUM]] = 'pmin';
            typeMap[PLACE_NAMES[ENTRY_PLACES.GUARANTEE]] = 'min';

            $prices.removeClass('b-phrases-list__price-hilite__num_hilited_yes');

            placeName = PLACE_NAMES[brokerResponse.place_name];

            if (typeMap[placeName]) {
                $prices
                    .filter('.b-phrases-list__price-hilite__num_type_' + typeMap[placeName])
                    .addClass('b-phrases-list__price-hilite__num_hilited_yes');
            }
        }
    };
})(jQuery, window.Lego);
