(function($, Lego) { 

    var inputs = [],
        labels = [],
        pi = parseInt,
        cleanerLaunched;
        
    function hasNativeSupport(tagName) {
        var node = $(tagName != 'INPUT' ? '<input type="text" />' : '<textarea></textarea>')[0];
        return typeof(node.placeholder) == 'string';
    }
    
    function cleaner () {
        for (var i=0, l = inputs.length; i<l; i++) {
            if (inputs[i].val()) labels[i].hide();
        }
    }
    
Lego.block['b-placeholder'] = function(params) {
    var $this = $(this),
        text = $this.attr('placeholder');
    
    if (hasNativeSupport($this[0].tagName)) return;
    
    // var clone = $this.clone();
    // clone.css({ position: 'absolute', visibility: 'hidden', height: '20px', width: '20px', padding: '0', border: 'none', padding: '0' });
    // document.body.appendChild(clone[0]);
    // var dw = clone[0].offsetWidth - clone[0].clientWidth,
    //     dh = clone[0].offsetHeight - clone[0].clientHeight;
    // document.body.removeChild(clone[0]);

    var label = $('<label>' + text + '</label>');

    label.css({
        position: 'absolute',
        left: $this[0].offsetLeft + pi($this.css('borderLeftWidth')) + 'px',
        top: $this[0].offsetTop + pi($this.css('borderTopWidth')) + 'px',
        padding: $this.css('padding'),
        display: 'block',
        cursor: 'text',
        color: '#999',
        fontFamily: $this.css('fontFamily'),
        // fontSize: $this.css('fontSize'),
        lineHeight: $this.css('lineHeight'),
        width: params.width || $this.css('width')
    });

    if ($this.parent().css('position') == 'static') $this.parent().css('position','relative');
    $this.after(label);
    inputs.push($this);
    labels.push(label);
    
    label.click(function() {
        $this.focus();
    });
    
    $this.focus(function() {
        label.hide();
    });
    
    $this.blur(function() {
        if (!$this.val()) label.show();
    });
    
    if (!cleanerLaunched) {
        cleanerLaunched = true;
        setInterval(cleaner, 100);
    }
};
})(jQuery, window.Lego);