BEM.DOM.decl('b-plot-stat', {
    onSetMod: {
        js: function() {
            this._loadingCount = 0;

            this.plotcol = this.params.plotcol || 'all';

            this.bindTo('link', 'click', this.onLinkClick, this);

            this.bindTo('iframe', 'load', function() {
                !(--this._loadingCount) && this.delMod('loading');
            }, this);

            this._load();
        }
    },

    onLinkClick: function(e) {
        e.preventDefault();

        this.delMod(this.elem('link', 'col', this.plotcol), 'active');
        this.plotcol = this.getMod(e.data.domElem, 'col');
        this.setMod(e.data.domElem, 'active', 'yes');

        this._load();
    },

    _load: function() {
        var _this = this,
            links;

        this.setMod(this.elem('iframe'), 'hidden', 'yes');

        if (this.plotcol === 'all') {
            links = this.elem('link');

            this._loadingCount = links.length - 1;

            links.map(function() {
                var plotcol = _this.getMod($(this), 'col');

                plotcol !== 'all' && _this.loadPlot(plotcol);
            });
        } else {
            this._loadingCount = 1;

            this.loadPlot(this.plotcol);
        }
    },

    loadPlot: function(plotcol) {
        this.delMod(this.elem('iframe', 'col', plotcol), 'hidden');
        this.setMod('loading', 'yes');

        this.elem('form', 'col', plotcol).submit();
    }

});
